/*
 * Decompiled with CFR 0.152.
 */
package forestry.storage;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.StorageManager;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleHelper;
import forestry.storage.CrateRegistry;
import forestry.storage.items.ItemCrated;
import forestry.storage.items.ItemRegistryCrates;
import forestry.storage.models.ModelCrate;
import forestry.storage.proxy.ProxyStorage;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@ForestryModule(moduleID="crates", containerID="forestry", name="Crate", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.crates.description")
public class ModuleCrates
extends BlankForestryModule {
    private static final List<ItemCrated> crates = new ArrayList<ItemCrated>();
    @SidedProxy(clientSide="forestry.storage.proxy.ProxyStorageClient", serverSide="forestry.storage.proxy.ProxyStorage")
    public static ProxyStorage proxy;
    @Nullable
    private static ItemRegistryCrates items;

    public static ItemRegistryCrates getItems() {
        Preconditions.checkState((items != null ? 1 : 0) != 0);
        return items;
    }

    @Override
    public void setupAPI() {
        StorageManager.crateRegistry = new CrateRegistry();
        proxy.registerCrateModel();
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryCrates();
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public Set<ResourceLocation> getDependencyUids() {
        return ImmutableSet.of((Object)new ResourceLocation("forestry", "core"));
    }

    @Override
    public void registerRecipes() {
        ItemRegistryCrates items = ModuleCrates.getItems();
        if (ModuleHelper.isEnabled("factory")) {
            RecipeManagers.carpenterManager.addRecipe(20, new FluidStack(FluidRegistry.WATER, 1000), ItemStack.field_190927_a, items.crate.getItemStack(24), " # ", "# #", " # ", Character.valueOf('#'), "logWood");
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onBakeModel(ModelBakeEvent event) {
        ModelCrate.onModelBake(event);
    }

    public static void registerCrate(ItemCrated crate) {
        crates.add(crate);
    }

    public static void createCrateRecipes() {
        for (ItemCrated crate : crates) {
            ItemStack crateStack = new ItemStack((Item)crate);
            ItemStack uncrated = crate.getContained();
            if (uncrated.func_190926_b()) continue;
            if (crate.getOreDictName() != null) {
                ModuleCrates.addCrating(crateStack, crate.getOreDictName());
            } else {
                ModuleCrates.addCrating(crateStack, uncrated);
            }
            ModuleCrates.addUncrating(crateStack, uncrated);
        }
    }

    private static void addCrating(ItemStack crateStack, Object uncrated) {
        FluidStack water = new FluidStack(FluidRegistry.WATER, 100);
        ItemStack box = ModuleCrates.getItems().crate.getItemStack();
        RecipeManagers.carpenterManager.addRecipe(5, water, box, crateStack, "###", "###", "###", Character.valueOf('#'), uncrated);
    }

    private static void addUncrating(ItemStack crateStack, ItemStack uncrated) {
        ItemStack product = new ItemStack(uncrated.func_77973_b(), 9, uncrated.func_77952_i());
        RecipeManagers.carpenterManager.addRecipe(5, ItemStack.field_190927_a, product, "#", Character.valueOf('#'), crateStack);
    }
}

