/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.gui.IGuiElement;
import forestry.core.gui.elements.GuiState;
import forestry.core.gui.elements.layouts.ElementGroup;
import forestry.core.gui.elements.layouts.PaneLayout;
import java.util.List;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraftforge.fml.client.config.GuiUtils;

public class ElementManager<G extends GuiScreen> {
    private final GuiState<G> state;
    private final ElementGroup container;

    public ElementManager(G gui) {
        this.state = new GuiState<G>(gui);
        this.container = new PaneLayout(0, 0);
        this.container.setGuiState(this.state);
    }

    public ElementGroup group() {
        return this.container;
    }

    public void add(IGuiElement element) {
        this.container.add(element);
    }

    public void remove(IGuiElement element) {
        this.container.remove(element);
    }

    public void clear() {
        this.container.clear();
    }

    public void draw(int mouseX, int mouseY) {
        this.state.setMouseX(mouseX);
        this.state.setMouseY(mouseY);
        this.container.draw(mouseX, mouseY);
    }

    public void init(int guiLeft, int guiTop) {
        this.container.setLocation(guiLeft, guiTop);
    }

    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        this.container.mouseClicked(mouseX, mouseY, mouseButton);
    }

    public void mouseClickMove(int mouseX, int mouseY, int mouseButton) {
        this.container.mouseClickMove(mouseX, mouseY, mouseButton);
    }

    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
        this.container.mouseReleased(mouseX, mouseY, mouseButton);
    }

    public boolean keyTyped(char typedChar, int keyCode) {
        return this.container.keyTyped(typedChar, keyCode);
    }

    public void drawTooltip(int mouseX, int mouseY) {
        List<String> lines = this.getTooltip(mouseX, mouseY);
        if (!lines.isEmpty()) {
            GlStateManager.func_179094_E();
            ScaledResolution scaledresolution = new ScaledResolution(this.state.getMinecraft());
            GuiUtils.drawHoveringText(lines, (int)mouseX, (int)mouseY, (int)scaledresolution.func_78326_a(), (int)scaledresolution.func_78328_b(), (int)-1, (FontRenderer)this.state.getFontRenderer());
            GlStateManager.func_179121_F();
        }
    }

    public boolean isMouseOver(int mouseX, int mouseY) {
        int mX = mouseX - this.container.getX();
        int mY = mouseY - this.container.getY();
        return this.getElements().stream().anyMatch(element -> element.isMouseOver(mX, mY));
    }

    public List<String> getTooltip(int mouseX, int mouseY) {
        return this.container.getTooltip(mouseX, mouseY);
    }

    public List<IGuiElement> getElements() {
        return this.container.getElements();
    }
}

