/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.core.ForestryAPI;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.core.ModuleCore;
import forestry.core.fluids.Fluids;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.modules.ModuleHelper;
import forestry.plugins.CompatPlugin;
import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;

@ForestryModule(containerID="forestry_compat", moduleID="biomes.o.plenty", name="BiomesOPlenty", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.biomesoplenty.description")
public class PluginBiomesOPlenty
extends CompatPlugin {
    @Nullable
    private static Block saplings;
    @Nullable
    private static Block colorizedSaplings;
    @Nullable
    private static Item food;
    private static int amount;

    public PluginBiomesOPlenty() {
        super("BiomesOPlenty", "biomesoplenty");
    }

    @Override
    public void doInit() {
        saplings = this.getBlock("saplings");
        colorizedSaplings = this.getBlock("colorizedSaplings");
        food = this.getItem("food");
        if (ModuleHelper.isEnabled("apiculture")) {
            PluginBiomesOPlenty.addFlowers();
        }
        if (ModuleHelper.isEnabled("farming")) {
            this.addFarmCrops();
        }
    }

    @Override
    public void registerRecipes() {
        amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        if (ModuleHelper.isEnabled("factory")) {
            PluginBiomesOPlenty.addFermenterRecipes();
            this.addSqueezerRecipes();
        }
    }

    private void addFarmCrops() {
        Item boPTurnipSeeds;
        ItemStack boPTurnipSeedStack;
        ArrayList<String> saplingItemKeys = new ArrayList<String>();
        if (saplings != null) {
            saplingItemKeys.add("saplings");
        }
        if (colorizedSaplings != null) {
            saplingItemKeys.add("colorizedSaplings");
        }
        for (String key : saplingItemKeys) {
            Item saplingItem = this.getItem(key);
            String saplingName = ItemStackUtil.getItemNameFromRegistryAsString(saplingItem);
            if (saplingName == null) continue;
            FMLInterModComms.sendMessage((String)"forestry", (String)"add-farmable-sapling", (String)String.format("farmArboreal@%s.-1", saplingName));
        }
        Block boPTurnip = this.getBlock("turnip");
        if (ModuleHelper.isEnabled("farming") && boPTurnip != null && !(boPTurnipSeedStack = new ItemStack(boPTurnipSeeds = this.getItem("turnipSeeds"), 1, 0)).func_190926_b() && ModuleHelper.isEnabled("factory")) {
            RecipeManagers.squeezerManager.addRecipe(10, boPTurnipSeedStack, Fluids.SEED_OIL.getFluid(amount));
        }
    }

    private static void addFermenterRecipes() {
        int saplingYield = ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling");
        if (saplings != null && saplings != Blocks.field_150350_a) {
            RecipeUtil.addFermenterRecipes(new ItemStack(saplings, 1, Short.MAX_VALUE), saplingYield, Fluids.BIOMASS);
        }
        if (colorizedSaplings != null && colorizedSaplings != Blocks.field_150350_a) {
            RecipeUtil.addFermenterRecipes(new ItemStack(colorizedSaplings, 1, Short.MAX_VALUE), saplingYield, Fluids.BIOMASS);
        }
    }

    private void addSqueezerRecipes() {
        Item persimmon;
        ItemStack mulch = new ItemStack((Item)ModuleCore.getItems().mulch);
        Item pinecone = this.getItem("pinecone");
        if (pinecone != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(pinecone), Fluids.SEED_OIL.getFluid(3 * amount));
        }
        if (food != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(food), Fluids.JUICE.getFluid(50), mulch, 5);
        }
        if ((persimmon = this.getItem("persimmon")) != null) {
            RecipeManagers.squeezerManager.addRecipe(10, new ItemStack(persimmon), Fluids.JUICE.getFluid(200), mulch, 20);
        }
    }

    private static void addFlowers() {
    }

    @Override
    public void registerBackpackItems() {
        this.addBlocksToBackpack("forestry.miner", "driedDirt", "overgrownNetherrack", "cragRock", "ashStone");
        this.addBlocksToBackpack("forestry.digger", "bopGrass", "newBopGrass", "longGrass", "mud", "hardDirt", "hardSand", "originGrass", "ash", "newBopDirt");
        this.addBlocksToBackpack("forestry.forester", "petals");
    }
}

