/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.lepidopterology.EnumFlutterType;
import forestry.api.lepidopterology.IAlleleButterflySpecies;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.config.Config;
import forestry.core.genetics.analyzer.DatabasePlugin;
import forestry.core.genetics.analyzer.MutationsTab;
import forestry.lepidopterology.ModuleLepidopterology;
import forestry.lepidopterology.genetics.ButterflyDatabaseTab;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import forestry.lepidopterology.genetics.ButterflyGenome;
import forestry.lepidopterology.genetics.ButterflyProductsTab;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ButterflyPlugin
extends DatabasePlugin<IButterfly> {
    public static final ButterflyPlugin INSTANCE = new ButterflyPlugin();
    protected final Map<String, ItemStack> iconStacks = new HashMap<String, ItemStack>();

    private ButterflyPlugin() {
        super(new ButterflyDatabaseTab(true), new ButterflyDatabaseTab(false), new ButterflyProductsTab(), new MutationsTab(() -> ButterflyDefinition.Glasswing.getMemberStack(EnumFlutterType.COCOON)));
        NonNullList butterflyList = NonNullList.func_191196_a();
        ModuleLepidopterology.getItems().butterflyGE.addCreativeItems((NonNullList<ItemStack>)butterflyList, false);
        for (ItemStack butterflyStack : butterflyList) {
            IAlleleButterflySpecies species = ButterflyGenome.getSpecies(butterflyStack);
            this.iconStacks.put(species.getUID(), butterflyStack);
        }
    }

    @Override
    public Map<String, ItemStack> getIndividualStacks() {
        return this.iconStacks;
    }

    @Override
    public List<String> getHints() {
        return Config.hints.get((Object)"flutterlyzer");
    }
}

