/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.genetics;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IDatabaseTab;
import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IElementGenetic;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.core.genetics.alleles.AlleleBoolean;
import forestry.core.render.ColourProperties;
import forestry.core.utils.StringUtil;
import forestry.core.utils.Translator;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BeeDatabaseTab
implements IDatabaseTab<IBee> {
    private final boolean active;

    BeeDatabaseTab(boolean active) {
        this.active = active;
    }

    @Override
    public void createElements(IElementGenetic container, IBee bee, ItemStack itemStack) {
        String nocturnal;
        String diurnal;
        EnumBeeType type = BeeManager.beeRoot.getType(itemStack);
        if (type == null) {
            return;
        }
        IAlleleBeeSpecies primarySpecies = bee.getGenome().getPrimary();
        container.text(Translator.translateToLocal("for.gui.database.tab." + (this.active ? "active" : "inactive") + "_species.name"), GuiElementAlignment.TOP_CENTER, 13612347);
        container.addAlleleRow(Translator.translateToLocal("for.gui.species"), bee, EnumBeeChromosome.SPECIES, this.active);
        IAlleleTolerance tempTolerance = (IAlleleTolerance)(this.active ? bee.getGenome().getActiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE) : bee.getGenome().getInactiveAllele(EnumBeeChromosome.TEMPERATURE_TOLERANCE));
        container.addToleranceInfo(Translator.translateToLocal("for.gui.climate"), tempTolerance, primarySpecies, AlleleManager.climateHelper.toDisplay(primarySpecies.getTemperature()));
        IAlleleTolerance humidTolerance = (IAlleleTolerance)(this.active ? bee.getGenome().getActiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE) : bee.getGenome().getInactiveAllele(EnumBeeChromosome.HUMIDITY_TOLERANCE));
        container.addToleranceInfo(Translator.translateToLocal("for.gui.humidity"), humidTolerance, primarySpecies, AlleleManager.climateHelper.toDisplay(primarySpecies.getHumidity()));
        container.addAlleleRow(Translator.translateToLocal("for.gui.lifespan"), bee, EnumBeeChromosome.LIFESPAN, this.active);
        container.addAlleleRow(Translator.translateToLocal("for.gui.speed"), bee, EnumBeeChromosome.SPEED, this.active);
        container.addAlleleRow(Translator.translateToLocal("for.gui.pollination"), bee, EnumBeeChromosome.FLOWERING, this.active);
        container.addAlleleRow(Translator.translateToLocal("for.gui.flowers"), bee, EnumBeeChromosome.FLOWER_PROVIDER, this.active);
        IAlleleInteger primaryFertility = (IAlleleInteger)(this.active ? bee.getGenome().getActiveAllele(EnumBeeChromosome.FERTILITY) : bee.getGenome().getInactiveAllele(EnumBeeChromosome.FERTILITY));
        container.addFertilityInfo(Translator.translateToLocal("for.gui.fertility"), primaryFertility, 0);
        container.addAlleleRow(Translator.translateToLocal("for.gui.area"), bee, EnumBeeChromosome.TERRITORY, this.active);
        container.addAlleleRow(Translator.translateToLocal("for.gui.effect"), bee, EnumBeeChromosome.EFFECT, this.active);
        String yes = Translator.translateToLocal("for.yes");
        String no = Translator.translateToLocal("for.no");
        if (this.active) {
            if (bee.getGenome().getNeverSleeps()) {
                nocturnal = diurnal = yes;
            } else {
                nocturnal = bee.getGenome().getPrimary().isNocturnal() ? yes : no;
                diurnal = !bee.getGenome().getPrimary().isNocturnal() ? yes : no;
            }
        } else if (((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumButterflyChromosome.NOCTURNAL)).getValue()) {
            nocturnal = diurnal = yes;
        } else {
            nocturnal = bee.getGenome().getSecondary().isNocturnal() ? yes : no;
            diurnal = !bee.getGenome().getSecondary().isNocturnal() ? yes : no;
        }
        container.addRow(Translator.translateToLocal("for.gui.diurnal"), diurnal, false);
        container.addRow(Translator.translateToLocal("for.gui.nocturnal"), nocturnal, false);
        String flyer = StringUtil.readableBoolean(this.active ? bee.getGenome().getToleratesRain() : ((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.TOLERATES_RAIN)).getValue(), yes, no);
        container.addAlleleRow(Translator.translateToLocal("for.gui.flyer"), a -> flyer, bee, EnumButterflyChromosome.TOLERANT_FLYER, this.active);
        String cave = StringUtil.readableBoolean(this.active ? bee.getGenome().getCaveDwelling() : ((AlleleBoolean)bee.getGenome().getInactiveAllele(EnumBeeChromosome.CAVE_DWELLING)).getValue(), yes, no);
        container.addAlleleRow(Translator.translateToLocal("for.gui.cave"), a -> cave, bee, EnumButterflyChromosome.FIRE_RESIST, this.active);
        if (type == EnumBeeType.PRINCESS || type == EnumBeeType.QUEEN) {
            String displayTextKey = "for.bees.stock.pristine";
            if (!bee.isNatural()) {
                displayTextKey = "for.bees.stock.ignoble";
            }
            String displayText = Translator.translateToLocal(displayTextKey);
            container.text(displayText, GuiElementAlignment.TOP_CENTER, ColourProperties.INSTANCE.get("gui.beealyzer.binomial"));
        }
    }

    @Override
    public ItemStack getIconStack() {
        return BeeDefinition.MEADOWS.getMemberStack(this.active ? EnumBeeType.PRINCESS : EnumBeeType.DRONE);
    }
}

