package forestry.farming.logic.farmables;

import javax.annotation.Nullable;

import net.minecraft.block.BlockChorusFlower;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.crops.CropChorusFlower;

public class FarmableChorus implements IFarmable {
	public static final IFarmable INSTANCE = new FarmableChorus();

	private final ItemStack germling;
	private final ItemStack fruit;

	private FarmableChorus() {
		this.germling = new ItemStack(Blocks.field_185766_cS);
		this.fruit = new ItemStack(Items.field_185161_cS);
	}

	@Override
	public boolean isSaplingAt(World world, BlockPos pos, IBlockState blockState) {
		return blockState.func_177230_c() == Blocks.field_185766_cS;
	}

	@Nullable
	@Override
	public ICrop getCropAt(World world, BlockPos pos, IBlockState blockState) {
		if (blockState.func_177230_c() != Blocks.field_185766_cS) {
			return null;
		}

		if (blockState.func_177229_b(BlockChorusFlower.field_185607_a) < 5) {
			return null;
		}

		return new CropChorusFlower(world, pos);
	}

	@Override
	public boolean isGermling(ItemStack itemstack) {
		return ItemStack.func_179545_c(germling, itemstack);
	}

	@Override
	public boolean isWindfall(ItemStack itemstack) {
		return ItemStack.func_179545_c(fruit, itemstack);
	}

	@Override
	public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
		if (!canPlace(world, pos)) {
			return false;
		}
		return BlockUtil.setBlockWithPlaceSound(world, pos, Blocks.field_185766_cS.func_176223_P());
	}

	private boolean canPlace(World world, BlockPos position) {
		for (int x = -1; x <= 1; x++) {
			for (int z = -1; z <= 1; z++) {
				BlockPos offsetPosition = position.func_177982_a(x, 0, z);
				IBlockState state = world.func_180495_p(offsetPosition);
				if (state.func_177230_c() == Blocks.field_185766_cS || state.func_177230_c() == Blocks.field_185765_cR) {
					return false;
				}
			}
		}

		return true;
	}
}
