package forestry.database.inventory;

import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.inventory.InventoryAdapterTile;
import forestry.database.tiles.TileDatabase;
import forestry.core.utils.GeneticsUtil;

public class InventoryDatabase extends InventoryAdapterTile<TileDatabase> {
	public InventoryDatabase(TileDatabase tile) {
		super(tile, 136, "Items");
	}

	@Override
	public boolean canSlotAccept(int slotIndex, ItemStack itemStack) {
		itemStack = GeneticsUtil.convertToGeneticEquivalent(itemStack);
		ISpeciesRoot speciesRoot = AlleleManager.alleleRegistry.getSpeciesRoot(itemStack);
		if (speciesRoot == null) {
			return false;
		}
		return true;
	}

	@Override
	public boolean func_180461_b(int slotIndex, ItemStack stack, EnumFacing side) {
		return super.func_180461_b(slotIndex, stack, side);
	}
}
