/*
 * Decompiled with CFR 0.152.
 */
package forestry.book.gui.elements;

import forestry.book.data.TextData;
import forestry.core.gui.elements.GuiElement;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TextDataElement
extends GuiElement {
    private final List<TextData> textElements = new ArrayList<TextData>();

    public TextDataElement(int xPos, int yPos, int width, int height) {
        super(xPos, yPos, width, height);
    }

    @Override
    public int getHeight() {
        if (this.height >= 0) {
            return this.height;
        }
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        boolean unicode = fontRenderer.func_82883_a();
        fontRenderer.func_78264_a(true);
        boolean lastEmpty = false;
        for (TextData data : this.textElements) {
            if (data.text.equals("\n")) {
                if (lastEmpty) {
                    this.height += fontRenderer.field_78288_b;
                }
                lastEmpty = true;
                continue;
            }
            lastEmpty = false;
            if (data.paragraph) {
                this.height = (int)((double)this.height + (double)fontRenderer.field_78288_b * 1.6);
            }
            String modifiers = "";
            modifiers = modifiers + TextFormatting.func_96300_b((String)data.color);
            if (data.bold) {
                modifiers = modifiers + TextFormatting.BOLD;
            }
            if (data.italic) {
                modifiers = modifiers + TextFormatting.ITALIC;
            }
            if (data.underlined) {
                modifiers = modifiers + TextFormatting.UNDERLINE;
            }
            if (data.strikethrough) {
                modifiers = modifiers + TextFormatting.STRIKETHROUGH;
            }
            if (data.obfuscated) {
                modifiers = modifiers + TextFormatting.OBFUSCATED;
            }
            this.height += fontRenderer.func_78267_b(modifiers + data.text, this.width);
        }
        fontRenderer.func_78264_a(unicode);
        return this.height;
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        boolean unicode = fontRenderer.func_82883_a();
        fontRenderer.func_78264_a(true);
        int x = 0;
        int y = 0;
        for (TextData data : this.textElements) {
            if (data.text.equals("\n")) {
                x = 0;
                y += fontRenderer.field_78288_b;
                continue;
            }
            if (data.paragraph) {
                x = 0;
                y = (int)((double)y + (double)fontRenderer.field_78288_b * 1.6);
            }
            String text = this.getFormattedString(data);
            List split = fontRenderer.func_78271_c(text, this.width);
            for (int i = 0; i < split.size(); ++i) {
                String s = (String)split.get(i);
                int textLength = fontRenderer.func_175065_a(s, (float)x, (float)y, 0, data.dropshadow);
                if (i == split.size() - 1) {
                    x += textLength;
                    continue;
                }
                y += fontRenderer.field_78288_b;
            }
        }
        fontRenderer.func_78264_a(unicode);
    }

    private String getFormattedString(TextData data) {
        StringBuilder modifiers = new StringBuilder();
        modifiers.append(TextFormatting.func_96300_b((String)data.color));
        if (data.bold) {
            modifiers.append(TextFormatting.BOLD);
        }
        if (data.italic) {
            modifiers.append(TextFormatting.ITALIC);
        }
        if (data.underlined) {
            modifiers.append(TextFormatting.UNDERLINE);
        }
        if (data.strikethrough) {
            modifiers.append(TextFormatting.STRIKETHROUGH);
        }
        if (data.obfuscated) {
            modifiers.append(TextFormatting.OBFUSCATED);
        }
        modifiers.append(data.text);
        return modifiers.toString();
    }

    public void addData(TextData textData) {
        this.textElements.add(textData);
        this.height = -1;
    }
}

