/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.crops;

import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.NetworkUtil;
import forestry.farming.logic.crops.Crop;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;

public class CropDestroy
extends Crop {
    protected final IBlockState blockState;
    @Nullable
    protected final IBlockState replantState;
    protected final ItemStack germling;

    public CropDestroy(World world, IBlockState blockState, BlockPos position, @Nullable IBlockState replantState) {
        this(world, blockState, position, replantState, ItemStack.field_190927_a);
    }

    public CropDestroy(World world, IBlockState blockState, BlockPos position, @Nullable IBlockState replantState, ItemStack germling) {
        super(world, position);
        this.blockState = blockState;
        this.replantState = replantState;
        this.germling = germling;
    }

    @Override
    protected boolean isCrop(World world, BlockPos pos) {
        return world.func_180495_p(pos) == this.blockState;
    }

    @Override
    protected NonNullList<ItemStack> harvestBlock(World world, BlockPos pos) {
        Block block = this.blockState.func_177230_c();
        NonNullList harvested = NonNullList.func_191196_a();
        harvested.addAll((Collection)block.getDrops((IBlockAccess)world, pos, this.blockState, 0));
        float chance = ForgeEventFactory.fireBlockHarvesting((List)harvested, (World)world, (BlockPos)pos, (IBlockState)this.blockState, (int)0, (float)1.0f, (boolean)false, null);
        boolean removedSeed = this.germling.func_190926_b();
        Iterator dropIterator = harvested.iterator();
        while (dropIterator.hasNext()) {
            ItemStack next = (ItemStack)dropIterator.next();
            if (world.field_73012_v.nextFloat() <= chance) {
                if (removedSeed || !ItemStackUtil.isIdenticalItem(next, this.germling)) continue;
                next.func_190918_g(1);
                if (next.func_190926_b()) {
                    dropIterator.remove();
                }
                removedSeed = true;
                continue;
            }
            dropIterator.remove();
        }
        PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.VisualFXType.BLOCK_BREAK, PacketFXSignal.SoundFXType.BLOCK_BREAK, pos, this.blockState);
        NetworkUtil.sendNetworkPacket(packet, pos, world);
        if (this.replantState != null) {
            world.func_180501_a(pos, this.replantState, 2);
        } else {
            world.func_175698_g(pos);
        }
        return harvested;
    }

    public String toString() {
        return String.format("CropDestroy [ position: [ %s ]; block: %s ]", this.position.toString(), this.blockState);
    }
}

