/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.multiblock;

import forestry.api.climate.IClimateControlled;
import forestry.api.multiblock.IAlvearyComponent;
import forestry.apiculture.multiblock.TileAlveary;
import forestry.core.network.packets.PacketActiveUpdate;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.NetworkUtil;
import forestry.energy.EnergyHelper;
import forestry.energy.EnergyManager;
import forestry.energy.EnergyTransferMode;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;

public abstract class TileAlvearyClimatiser
extends TileAlveary
implements IActivatable,
IAlvearyComponent.Climatiser {
    private static final int WORK_CYCLES = 1;
    private static final int ENERGY_PER_OPERATION = 50;
    private final EnergyManager energyManager;
    private final IClimitiserDefinition definition;
    private int workingTime = 0;
    private boolean active;

    protected TileAlvearyClimatiser(IClimitiserDefinition definition) {
        this.definition = definition;
        this.energyManager = new EnergyManager(1000, 2000);
        this.energyManager.setExternalMode(EnergyTransferMode.RECEIVE);
    }

    @Override
    public void changeClimate(int tick, IClimateControlled climateControlled) {
        if (this.workingTime < 20 && EnergyHelper.consumeEnergyToDoWork(this.energyManager, 1, 50)) {
            this.workingTime += 5;
        }
        if (this.workingTime > 0) {
            --this.workingTime;
            climateControlled.addTemperatureChange(this.definition.getChangePerTransfer(), this.definition.getBoundaryDown(), this.definition.getBoundaryUp());
        }
        this.setActive(this.workingTime > 0);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbttagcompound) {
        super.func_145839_a(nbttagcompound);
        this.energyManager.readFromNBT(nbttagcompound);
        this.workingTime = nbttagcompound.func_74762_e("Heating");
        this.setActive(this.workingTime > 0);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbttagcompound) {
        nbttagcompound = super.func_189515_b(nbttagcompound);
        this.energyManager.writeToNBT(nbttagcompound);
        nbttagcompound.func_74768_a("Heating", this.workingTime);
        return nbttagcompound;
    }

    @Override
    protected void encodeDescriptionPacket(NBTTagCompound packetData) {
        super.encodeDescriptionPacket(packetData);
        packetData.func_74757_a("Active", this.active);
    }

    @Override
    protected void decodeDescriptionPacket(NBTTagCompound packetData) {
        super.decodeDescriptionPacket(packetData);
        this.setActive(packetData.func_74767_n("Active"));
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public void setActive(boolean active) {
        if (this.active == active) {
            return;
        }
        this.active = active;
        if (this.field_145850_b != null) {
            if (this.field_145850_b.field_72995_K) {
                this.field_145850_b.func_175704_b(this.func_174877_v(), this.func_174877_v());
            } else {
                NetworkUtil.sendNetworkPacket(new PacketActiveUpdate(this), this.field_174879_c, this.field_145850_b);
            }
        }
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return this.energyManager.hasCapability(capability) || super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        T energyCapability = this.energyManager.getCapability(capability);
        if (energyCapability != null) {
            return energyCapability;
        }
        return (T)super.getCapability(capability, facing);
    }

    protected static interface IClimitiserDefinition {
        public float getChangePerTransfer();

        public float getBoundaryUp();

        public float getBoundaryDown();
    }
}

