/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/

package forestry.apiculture;

import net.minecraft.block.Block;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import forestry.api.apiculture.EnumBeeType;
import forestry.apiculture.blocks.BlockApiculture;
import forestry.apiculture.items.ItemBeeGE;
import forestry.apiculture.tiles.TileBeeHouse;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.InventoryUtil;

public class ApiaristAI extends EntityAIMoveToBlock {
	private final EntityVillager villager;
	private boolean hasDrone;
	private boolean hasPrincess;
	private InventoryBasic villagerInventory;

	private static final int SLOT_PRODUCT_1 = InventoryBeeHousing.SLOT_PRODUCT_1;
	private static final int SLOT_PRODUCT_COUNT = InventoryBeeHousing.SLOT_PRODUCT_COUNT;
	private static final int SLOT_QUEEN = InventoryBeeHousing.SLOT_QUEEN;
	private static final int SLOT_DRONE = InventoryBeeHousing.SLOT_DRONE;

	public ApiaristAI(EntityVillager villager, double speed) {
		super(villager, speed, 16);
		this.villager = villager;
		villagerInventory = villager.func_175551_co();
	}

	@Override
	public boolean func_75250_a() {
		if (this.field_179496_a <= 0) {
			this.hasDrone = hasBeeType(EnumBeeType.DRONE);
			this.hasPrincess = hasBeeType(EnumBeeType.PRINCESS);
		}
		return super.func_75250_a();
	}

	@Override
	public void func_75246_d() {
		super.func_75246_d();
		BlockPos housePos = this.field_179494_b.func_177978_c().func_177984_a();
		this.villager.func_70671_ap().func_75650_a(housePos.func_177958_n() + 0.5D, housePos.func_177956_o(), housePos.func_177952_p() + 0.5D, 10.0F, this.villager.func_70646_bf());

		if (this.func_179487_f()) {
			World world = this.villager.field_70170_p;

			TileBeeHouse beeHouse = (TileBeeHouse) TileUtil.getTile(world, housePos);
			if (beeHouse == null) {
				return;
			}
			InventoryBeeHousing inventory = (InventoryBeeHousing) beeHouse.getBeeInventory();

			//fill slots from inside bee house
			for (ItemStack stack : InventoryUtil.getStacks(inventory, SLOT_PRODUCT_1, SLOT_PRODUCT_COUNT)) {
				if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBeeGE) {
					EnumBeeType type = ((ItemBeeGE) stack.func_77973_b()).getType();
					if (inventory.func_70301_a(SLOT_QUEEN).func_190926_b() && type == EnumBeeType.PRINCESS) {
						inventory.setQueen(stack.func_77946_l());
						stack.func_190920_e(0);
					} else if (type == EnumBeeType.DRONE) {
						stack.func_190918_g(InventoryUtil.addStack(inventory, stack, SLOT_DRONE, 1, true));
					}
				}

			}

			//fill slots from villager inventory
			if (inventory.func_70301_a(SLOT_DRONE).func_190926_b() || inventory.func_70301_a(SLOT_QUEEN).func_190926_b()) {
				boolean princessAdded = false;
				boolean droneAdded = false;
				for (ItemStack stack : InventoryUtil.getStacks(villagerInventory)) {
					if (princessAdded && droneAdded) {
						break;
					}
					if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBeeGE) {
						EnumBeeType type = ((ItemBeeGE) stack.func_77973_b()).getType();
						if (type == EnumBeeType.DRONE && inventory.func_70301_a(SLOT_DRONE).func_190926_b()) {
							InventoryUtil.addStack(inventory, stack, SLOT_DRONE, 1, true);
							droneAdded = true;
						} else if (type == EnumBeeType.PRINCESS && inventory.func_70301_a(SLOT_QUEEN).func_190926_b()) {
							InventoryUtil.addStack(inventory, stack, SLOT_QUEEN, 1, true);
							princessAdded = true;
						}
					}
				}
			}

			//add remaining bees to villager inventory
			for (ItemStack stack : InventoryUtil.getStacks(inventory, SLOT_PRODUCT_1, SLOT_PRODUCT_COUNT)) {
				if (stack.func_77973_b() instanceof ItemBeeGE) {
					InventoryUtil.addStack(villagerInventory, stack, true);
				}
			}
		}
		this.field_179496_a = 20;
	}

	public boolean hasBeeType(EnumBeeType type) {
		if (villagerInventory.func_191420_l()) {
			return false;
		}
		for (ItemStack stack : InventoryUtil.getStacks(villagerInventory)) {
			if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBeeGE) {
				if (((ItemBeeGE) stack.func_77973_b()).getType() == type) {
					return true;
				}
			}
		}
		return false;
	}

	protected boolean func_179488_a(World world, BlockPos pos) {
		pos = pos.func_177978_c().func_177984_a();
		Block block = world.func_180495_p(pos).func_177230_c();
		if (block instanceof BlockApiculture && TileUtil.getTile(world, pos) instanceof TileBeeHouse) {
			TileBeeHouse beeHouse = (TileBeeHouse) TileUtil.getTile(world, pos);
			InventoryBeeHousing inventory = (InventoryBeeHousing) beeHouse.getBeeInventory();
			if (inventory.func_191420_l()) {
				return false;
			}
			if (!inventory.func_70301_a(SLOT_QUEEN).func_190926_b()) {
				EnumBeeType type = ((ItemBeeGE) inventory.func_70301_a(SLOT_QUEEN).func_77973_b()).getType();
				if (type == EnumBeeType.QUEEN) {
					return false;
				}
				if (type == EnumBeeType.PRINCESS && !inventory.func_70301_a(SLOT_DRONE).func_190926_b() && !hasDrone) {
					return false;
				}
			}
			boolean foundPrincess = hasPrincess;
			boolean foundDrone = hasDrone;
			if (foundDrone && foundPrincess) {
				return true;
			}
			for (ItemStack stack : InventoryUtil.getStacks(inventory, SLOT_PRODUCT_1, SLOT_PRODUCT_COUNT)) {
				if (!stack.func_190926_b() && stack.func_77973_b() instanceof ItemBeeGE) {
					EnumBeeType type = ((ItemBeeGE) stack.func_77973_b()).getType();
					if (type == EnumBeeType.PRINCESS) {
						foundPrincess = true;
					}
					if (type == EnumBeeType.DRONE) {
						foundDrone = true;
					}
					if (foundDrone && foundPrincess) {
						return true;
					}
				}
			}
			return false;
			//maybe use error states instead?
		}
		return false;
	}
}
