/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements.layouts;

import com.google.common.collect.Lists;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IElementGenetic;
import forestry.api.gui.IElementGroup;
import forestry.api.gui.IElementLayout;
import forestry.api.gui.IGuiElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.layouts.PaneLayout;
import forestry.core.gui.elements.layouts.VerticalLayout;
import forestry.core.gui.widgets.IScrollable;
import forestry.core.render.ColourProperties;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.GlStateManager;
import org.lwjgl.opengl.GL11;

public class ScrollableElement
extends VerticalLayout
implements IScrollable,
IElementGenetic {
    private final List<IGuiElement> visibleElements = new ArrayList<IGuiElement>();
    private final int sizeY;
    private int elementOffset;
    private float scrollPercentage;
    private float step;

    public ScrollableElement(int xPos, int yPos, int width, int height) {
        super(xPos, yPos, width);
        this.sizeY = height;
    }

    public void updateVisibleElements(int offset) {
        this.visibleElements.clear();
        int height = 0;
        int widgetEnd = this.yPos + this.sizeY;
        for (int i = 0; i < this.elements.size(); ++i) {
            IGuiElement element = (IGuiElement)this.elements.get(i);
            if (i < offset) {
                height += element.getHeight();
                continue;
            }
            this.elementOffset = -height;
            int elementHeight = element.getY() + element.getHeight() + this.elementOffset;
            if (elementHeight > widgetEnd) continue;
            this.visibleElements.add(element);
        }
    }

    public int getInvisibleElementCount() {
        this.step = 6.0f;
        return (int)((float)(this.getHeight() - this.sizeY) / this.step);
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
        GL11.glEnable((int)3089);
        Minecraft mc = Minecraft.func_71410_x();
        ScaledResolution res = new ScaledResolution(mc);
        double scaleWidth = (double)mc.field_71443_c / res.func_78327_c();
        double scaleHeight = (double)mc.field_71440_d / res.func_78324_d();
        GL11.glScissor((int)((int)((double)this.getAbsoluteX() * scaleWidth)), (int)((int)((double)mc.field_71440_d - (double)(this.getAbsoluteY() + this.sizeY) * scaleHeight)), (int)((int)((double)this.width * scaleWidth)), (int)((int)((double)this.sizeY * scaleHeight)));
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)0.0f, (float)(-((int)this.scrollPercentage)), (float)0.0f);
        for (IGuiElement element : this.elements) {
            element.draw(mouseX, mouseY);
        }
        GlStateManager.func_179121_F();
        GL11.glDisable((int)3089);
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        mouseX -= this.getX();
        mouseY -= this.getY();
        for (IGuiElement element : this.visibleElements) {
            List<String> toolTip;
            if (!element.isMouseOver() || (toolTip = element.getTooltip(mouseX, mouseY)).isEmpty()) continue;
            return toolTip;
        }
        return Collections.emptyList();
    }

    @Override
    public void addFertilityInfo(String chromosomeName, IAlleleInteger fertilityAllele, int texOffset) {
        this.addRow(chromosomeName, GuiElementFactory.INSTANCE.createFertilityInfo(fertilityAllele, texOffset));
    }

    @Override
    public void addToleranceInfo(String chromosomeName, IAlleleTolerance toleranceAllele, IAlleleSpecies species, String text) {
        this.addRow(chromosomeName, text, species.isDominant());
        this.addRow("  " + Translator.translateToLocal("for.gui.tolerance"), (IGuiElement)GuiElementFactory.INSTANCE.createToleranceInfo(toleranceAllele));
    }

    @Override
    public void addMutation(int x, int y, int width, int height, IMutation mutation, IAllele species, IBreedingTracker breedingTracker) {
        IElementGroup element = GuiElementFactory.INSTANCE.createMutation(x, y, width, height, mutation, species, breedingTracker);
        if (element == null) {
            return;
        }
        this.add(element);
    }

    @Override
    public void addMutationResultant(int x, int y, int width, int height, IMutation mutation, IBreedingTracker breedingTracker) {
        IElementGroup element = GuiElementFactory.INSTANCE.createMutationResultant(x, y, width, height, mutation, breedingTracker);
        if (element == null) {
            return;
        }
        this.add(element);
    }

    @Override
    public void addRow(String firstText, String secondText, boolean dominant) {
        this.addRow(firstText, secondText, ColourProperties.INSTANCE.get("gui.screen"), GuiElementFactory.INSTANCE.getColorCoding(dominant));
    }

    @Override
    public final void addAlleleRow(String chromosomeName, IIndividual individual, IChromosomeType chromosome, boolean active) {
        this.addAlleleRow(chromosomeName, IAllele::getAlleleName, individual, chromosome, active);
    }

    @Override
    public void addRow(String firstText, String secondText, int firstColor, int secondColor) {
        IElementLayout first = this.addSplitText(this.width, firstText, GuiElementAlignment.TOP_LEFT, firstColor);
        IElementLayout second = this.addSplitText(this.width, secondText, GuiElementAlignment.TOP_LEFT, secondColor);
        this.addRow(first, (IGuiElement)second);
    }

    private IElementLayout addSplitText(int width, String text, GuiElementAlignment alignment, int color) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        VerticalLayout vertical = new VerticalLayout(width);
        for (String splitText : fontRenderer.func_78271_c(text, 70)) {
            vertical.text(splitText, alignment, color);
        }
        return vertical;
    }

    private void addRow(String chromosomeName, IGuiElement right) {
        int center = this.width / 2;
        IElementLayout first = this.addSplitText(center, chromosomeName, GuiElementAlignment.TOP_LEFT, ColourProperties.INSTANCE.get("gui.screen"));
        this.addRow(first, right);
    }

    private void addRow(IGuiElement first, IGuiElement second) {
        int center = this.width / 2;
        PaneLayout panel = new PaneLayout(this.width, 0);
        if (first.getHeight() > second.getHeight()) {
            first.setAlign(GuiElementAlignment.MIDDLE_LEFT);
        } else if (second.getHeight() > first.getHeight()) {
            second.setAlign(GuiElementAlignment.MIDDLE_LEFT);
        }
        panel.add(first);
        panel.add(second);
        second.setXPosition(center);
        this.add(panel);
    }

    @Override
    public final <A extends IAllele> void addAlleleRow(String chromosomeName, Function<A, String> toString, IIndividual individual, IChromosomeType chromosome, boolean active) {
        IAllele allele = active ? individual.getGenome().getActiveAllele(chromosome) : individual.getGenome().getInactiveAllele(chromosome);
        this.addRow(chromosomeName, toString.apply(allele), allele.isDominant());
    }

    @Override
    public void onScroll(int value) {
        this.scrollPercentage = (float)value * this.step;
    }

    @Override
    public void clear() {
        this.remove(Lists.newArrayList((Iterable)this.elements));
    }

    @Override
    public boolean isFocused(int mouseX, int mouseY) {
        return this.isMouseOver(mouseX, mouseY);
    }
}

