/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.EnumBeeType;
import forestry.apiculture.InventoryBeeHousing;
import forestry.apiculture.blocks.BlockApiculture;
import forestry.apiculture.items.ItemBeeGE;
import forestry.apiculture.tiles.TileBeeHouse;
import forestry.core.tiles.TileUtil;
import forestry.core.utils.InventoryUtil;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIMoveToBlock;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryBasic;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class ApiaristAI
extends EntityAIMoveToBlock {
    private final EntityVillager villager;
    private boolean hasDrone;
    private boolean hasPrincess;
    private InventoryBasic villagerInventory;
    private static final int SLOT_PRODUCT_1 = 2;
    private static final int SLOT_PRODUCT_COUNT = 7;
    private static final int SLOT_QUEEN = 0;
    private static final int SLOT_DRONE = 1;

    public ApiaristAI(EntityVillager villager, double speed) {
        super((EntityCreature)villager, speed, 16);
        this.villager = villager;
        this.villagerInventory = villager.func_175551_co();
    }

    public boolean func_75250_a() {
        if (this.field_179496_a <= 0) {
            this.hasDrone = this.hasBeeType(EnumBeeType.DRONE);
            this.hasPrincess = this.hasBeeType(EnumBeeType.PRINCESS);
        }
        return super.func_75250_a();
    }

    public void func_75246_d() {
        super.func_75246_d();
        BlockPos housePos = this.field_179494_b.func_177978_c().func_177984_a();
        this.villager.func_70671_ap().func_75650_a((double)housePos.func_177958_n() + 0.5, (double)housePos.func_177956_o(), (double)housePos.func_177952_p() + 0.5, 10.0f, (float)this.villager.func_70646_bf());
        if (this.func_179487_f()) {
            World world = this.villager.field_70170_p;
            TileBeeHouse beeHouse = (TileBeeHouse)TileUtil.getTile((IBlockAccess)world, housePos);
            if (beeHouse == null) {
                return;
            }
            InventoryBeeHousing inventory = (InventoryBeeHousing)beeHouse.getBeeInventory();
            for (ItemStack stack : InventoryUtil.getStacks((IInventory)inventory, 2, 7)) {
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBeeGE)) continue;
                EnumBeeType type = ((ItemBeeGE)stack.func_77973_b()).getType();
                if (inventory.func_70301_a(0).func_190926_b() && type == EnumBeeType.PRINCESS) {
                    inventory.setQueen(stack.func_77946_l());
                    stack.func_190920_e(0);
                    continue;
                }
                if (type != EnumBeeType.DRONE) continue;
                stack.func_190918_g(InventoryUtil.addStack((IInventory)inventory, stack, 1, 1, true));
            }
            if (inventory.func_70301_a(1).func_190926_b() || inventory.func_70301_a(0).func_190926_b()) {
                boolean princessAdded = false;
                boolean droneAdded = false;
                for (ItemStack stack : InventoryUtil.getStacks((IInventory)this.villagerInventory)) {
                    if (princessAdded && droneAdded) break;
                    if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBeeGE)) continue;
                    EnumBeeType type = ((ItemBeeGE)stack.func_77973_b()).getType();
                    if (type == EnumBeeType.DRONE && inventory.func_70301_a(1).func_190926_b()) {
                        InventoryUtil.addStack((IInventory)inventory, stack, 1, 1, true);
                        droneAdded = true;
                        continue;
                    }
                    if (type != EnumBeeType.PRINCESS || !inventory.func_70301_a(0).func_190926_b()) continue;
                    InventoryUtil.addStack((IInventory)inventory, stack, 0, 1, true);
                    princessAdded = true;
                }
            }
            for (ItemStack stack : InventoryUtil.getStacks((IInventory)inventory, 2, 7)) {
                if (!(stack.func_77973_b() instanceof ItemBeeGE)) continue;
                InventoryUtil.addStack((IInventory)this.villagerInventory, stack, true);
            }
        }
        this.field_179496_a = 20;
    }

    public boolean hasBeeType(EnumBeeType type) {
        if (this.villagerInventory.func_191420_l()) {
            return false;
        }
        for (ItemStack stack : InventoryUtil.getStacks((IInventory)this.villagerInventory)) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBeeGE) || ((ItemBeeGE)stack.func_77973_b()).getType() != type) continue;
            return true;
        }
        return false;
    }

    protected boolean func_179488_a(World world, BlockPos pos) {
        Block block = world.func_180495_p(pos = pos.func_177978_c().func_177984_a()).func_177230_c();
        if (block instanceof BlockApiculture && TileUtil.getTile((IBlockAccess)world, pos) instanceof TileBeeHouse) {
            TileBeeHouse beeHouse = (TileBeeHouse)TileUtil.getTile((IBlockAccess)world, pos);
            InventoryBeeHousing inventory = (InventoryBeeHousing)beeHouse.getBeeInventory();
            if (inventory.func_191420_l()) {
                return false;
            }
            if (!inventory.func_70301_a(0).func_190926_b()) {
                EnumBeeType type = ((ItemBeeGE)inventory.func_70301_a(0).func_77973_b()).getType();
                if (type == EnumBeeType.QUEEN) {
                    return false;
                }
                if (type == EnumBeeType.PRINCESS && !inventory.func_70301_a(1).func_190926_b() && !this.hasDrone) {
                    return false;
                }
            }
            boolean foundPrincess = this.hasPrincess;
            boolean foundDrone = this.hasDrone;
            if (foundDrone && foundPrincess) {
                return true;
            }
            for (ItemStack stack : InventoryUtil.getStacks((IInventory)inventory, 2, 7)) {
                if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ItemBeeGE)) continue;
                EnumBeeType type = ((ItemBeeGE)stack.func_77973_b()).getType();
                if (type == EnumBeeType.PRINCESS) {
                    foundPrincess = true;
                }
                if (type == EnumBeeType.DRONE) {
                    foundDrone = true;
                }
                if (!foundDrone || !foundPrincess) continue;
                return true;
            }
            return false;
        }
        return false;
    }
}

