/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting;

import com.google.common.base.Preconditions;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IFilterLogic;
import forestry.api.modules.ForestryModule;
import forestry.apiculture.ModuleApiculture;
import forestry.core.capabilities.NullStorage;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.lepidopterology.ModuleLepidopterology;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleHelper;
import forestry.sorting.DefaultFilterRuleType;
import forestry.sorting.DummyFilterRegistry;
import forestry.sorting.FakeFilterLogic;
import forestry.sorting.FilterRegistry;
import forestry.sorting.blocks.BlockRegistrySorting;
import forestry.sorting.network.PacketRegistrySorting;
import forestry.sorting.tiles.TileGeneticFilter;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.fml.common.registry.GameRegistry;

@ForestryModule(containerID="forestry", moduleID="sorting", name="Sorting", author="Nedelosk", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.sorting.description")
public class ModuleSorting
extends BlankForestryModule {
    @Nullable
    private static BlockRegistrySorting blocks;

    public static BlockRegistrySorting getBlocks() {
        Preconditions.checkState((blocks != null ? 1 : 0) != 0);
        return blocks;
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistrySorting();
    }

    @Override
    public void setupAPI() {
        AlleleManager.filterRegistry = new FilterRegistry();
        CapabilityManager.INSTANCE.register(IFilterLogic.class, new NullStorage(), () -> FakeFilterLogic.INSTANCE);
    }

    @Override
    public void disabledSetupAPI() {
        AlleleManager.filterRegistry = new DummyFilterRegistry();
        CapabilityManager.INSTANCE.register(IFilterLogic.class, new NullStorage(), () -> FakeFilterLogic.INSTANCE);
    }

    @Override
    public void registerItemsAndBlocks() {
        blocks = new BlockRegistrySorting();
    }

    @Override
    public void preInit() {
        DefaultFilterRuleType.init();
    }

    @Override
    public void registerRecipes() {
        if (ModuleHelper.isEnabled("apiculture")) {
            RecipeUtil.addRecipe("genetic_filter_api", new ItemStack((Block)ModuleSorting.getBlocks().filter, 2), "WDW", "PGP", "BDB", Character.valueOf('D'), "gemDiamond", Character.valueOf('W'), "plankWood", Character.valueOf('G'), "blockGlass", Character.valueOf('B'), "gearBronze", Character.valueOf('P'), ModuleApiculture.getItems().propolis);
        }
        if (ModuleHelper.isEnabled("arboriculture")) {
            RecipeUtil.addRecipe("genetic_filter_arb", new ItemStack((Block)ModuleSorting.getBlocks().filter, 2), "WDW", "FGF", "BDB", Character.valueOf('D'), "gemDiamond", Character.valueOf('W'), "plankWood", Character.valueOf('G'), "blockGlass", Character.valueOf('B'), "gearBronze", Character.valueOf('F'), "fruitForestry");
        }
        if (ModuleHelper.isEnabled("lepidopterology")) {
            RecipeUtil.addRecipe("genetic_filter_lep", new ItemStack((Block)ModuleSorting.getBlocks().filter, 2), "WDW", "FGF", "BDB", Character.valueOf('D'), "gemDiamond", Character.valueOf('W'), "plankWood", Character.valueOf('G'), "blockGlass", Character.valueOf('B'), "gearBronze", Character.valueOf('F'), ModuleLepidopterology.getItems().caterpillarGE);
        }
    }

    @Override
    public void doInit() {
        GameRegistry.registerTileEntity(TileGeneticFilter.class, (String)"forestry.GeneticFilter");
        ((FilterRegistry)AlleleManager.filterRegistry).init();
    }
}

