/*
 * Decompiled with CFR 0.152.
 */
package forestry.book;

import forestry.api.book.IBookCategory;
import forestry.api.book.IBookEntry;
import forestry.api.book.IBookEntryBuilder;
import forestry.book.BookEntryBuilder;
import forestry.core.utils.Translator;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BookCategory
implements IBookCategory {
    private final String name;
    private final transient Map<String, IBookEntry> entries = new LinkedHashMap<String, IBookEntry>();
    private ItemStack stack = ItemStack.field_190927_a;

    public BookCategory(String name) {
        this.name = name;
    }

    @Override
    public ItemStack getStack() {
        return this.stack;
    }

    @Override
    public IBookCategory setStack(ItemStack stack) {
        this.stack = stack;
        return this;
    }

    @Override
    public IBookCategory addEntry(IBookEntry entry) {
        this.entries.put(entry.getName(), entry);
        return this;
    }

    @Override
    public IBookCategory addEntry(String name, ItemStack stack) {
        BookEntryBuilder builder = new BookEntryBuilder(this, name);
        builder.setStack(stack);
        builder.addToCategory();
        return this;
    }

    @Override
    public IBookEntryBuilder createEntry(String name) {
        return new BookEntryBuilder(this, name);
    }

    @Override
    public IBookEntryBuilder createEntry(String name, ItemStack stack) {
        return new BookEntryBuilder(this, name).setStack(stack);
    }

    @Override
    public Collection<IBookEntry> getEntries() {
        return this.entries.values();
    }

    @Override
    @Nullable
    public IBookEntry getEntry(String name) {
        return this.entries.get(name);
    }

    @Override
    public String getLocalizedName() {
        return Translator.translateToLocal("for.gui.book.category." + this.name + ".title");
    }

    @Override
    public String getTooltip() {
        return "for.gui.book.category." + this.name + ".tooltip";
    }

    @Override
    public String getName() {
        return this.name;
    }
}

