/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.gui.elements;

import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IGuiElement;
import forestry.api.gui.IGuiState;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;

public class GuiElement
extends Gui
implements IGuiElement {
    protected int xPos;
    protected int yPos;
    protected final List<String> tooltip = new ArrayList<String>();
    protected int width;
    protected int height;
    protected GuiElementAlignment align = GuiElementAlignment.TOP_LEFT;
    @Nullable
    protected IGuiElement parent;
    @Nullable
    private IGuiState state;

    public GuiElement(int width, int height) {
        this(0, 0, width, height);
    }

    public GuiElement(int xPos, int yPos, int width, int height) {
        this.xPos = xPos;
        this.yPos = yPos;
        this.width = width;
        this.height = height;
    }

    @Override
    public int getX() {
        int x = 0;
        if (this.parent != null && this.parent.getWidth() > this.width) {
            x = (int)((float)(this.parent.getWidth() - this.width) * this.align.getXOffset());
        }
        return this.xPos + x;
    }

    @Override
    public int getY() {
        int y = 0;
        if (this.parent != null && this.parent.getHeight() > this.height) {
            y = (int)((float)(this.parent.getHeight() - this.height) * this.align.getYOffset());
        }
        return this.yPos + y;
    }

    @Override
    public final int getAbsoluteX() {
        return this.parent == null ? this.getX() : this.getX() + this.parent.getAbsoluteX();
    }

    @Override
    public final int getAbsoluteY() {
        return this.parent == null ? this.getY() : this.getY() + this.parent.getAbsoluteY();
    }

    @Override
    public void draw(int mouseX, int mouseY) {
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)this.getX(), (float)this.getY(), (float)0.0f);
        this.drawElement(mouseX, mouseY);
        GlStateManager.func_179121_F();
    }

    @Override
    public void drawElement(int mouseX, int mouseY) {
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void mouseReleased(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public void mouseClickMove(int mouseX, int mouseY, int mouseButton) {
    }

    @Override
    public boolean keyTyped(char typedChar, int keyCode) {
        return false;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public void setXPosition(int xPos) {
        this.xPos = xPos;
    }

    @Override
    public void setYPosition(int yPos) {
        this.yPos = yPos;
    }

    @Override
    public void setLocation(int xPos, int yPos) {
        this.xPos = xPos;
        this.yPos = yPos;
    }

    @Override
    public void setBounds(int xPos, int yPos, int width, int height) {
        this.setLocation(xPos, yPos);
        this.setSize(width, height);
    }

    @Override
    public void setAlign(GuiElementAlignment align) {
        this.align = align;
    }

    @Override
    public GuiElementAlignment getAlign() {
        return this.align;
    }

    @Override
    public boolean isMouseOver(int mouseX, int mouseY) {
        int x = this.getX();
        int y = this.getY();
        return mouseX >= x && mouseX <= this.getWidth() + x && mouseY >= y && mouseY <= this.getHeight() + y;
    }

    @Override
    public final boolean isMouseOver() {
        int mouseY;
        int mouseX;
        IGuiState guiState = this.getGuiState();
        if (guiState == null) {
            return false;
        }
        if (this.parent != null) {
            mouseX = guiState.getRelativeMouseX(this.parent);
            mouseY = guiState.getRelativeMouseY(this.parent);
        } else {
            mouseX = guiState.getMouseX();
            mouseY = guiState.getMouseY();
        }
        return this.isMouseOver(mouseX, mouseY);
    }

    @Override
    @Nullable
    public IGuiElement getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable IGuiElement parent) {
        this.parent = parent;
    }

    @Override
    public List<String> getTooltip(int mouseX, int mouseY) {
        return this.tooltip;
    }

    @Override
    public IGuiElement addTooltip(String line) {
        this.tooltip.add(line);
        return this;
    }

    @Override
    public IGuiElement addTooltip(Collection<String> lines) {
        this.tooltip.addAll(lines);
        return this;
    }

    @Override
    public void clearTooltip() {
        this.tooltip.clear();
    }

    @Override
    public List<String> getTooltip() {
        return this.tooltip;
    }

    @Override
    @Nullable
    public IGuiState getGuiState() {
        if (this.state == null && this.parent != null) {
            this.state = this.parent.getGuiState();
        }
        return this.state;
    }

    public void setGuiState(@Nullable IGuiState state) {
        this.state = state;
    }
}

