/*
 * Decompiled with CFR 0.152.
 */
package forestry.book.gui;

import forestry.api.book.IForesterBook;
import forestry.book.gui.buttons.GuiButtonBack;
import forestry.book.gui.buttons.GuiButtonPage;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.IGuiSizable;
import forestry.core.gui.elements.ElementManager;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.client.config.GuiUtils;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public abstract class GuiForesterBook
extends GuiScreen
implements IGuiSizable {
    public static final ResourceLocation TEXTURE = new ResourceLocation("forestry", "textures/gui/almanac/almanac.png");
    static final int LEFT_PAGE_START_X = 16;
    static final int RIGHT_PAGE_START_X = 132;
    static final int PAGE_START_Y = 12;
    static final int LEFT_PAGE_START_Y = 25;
    static final int RIGHT_PAGE_START_Y = 12;
    public static final int PAGE_WIDTH = 108;
    public static final int PAGE_HEIGHT = 155;
    private static final int X_SIZE = 256;
    private static final int Y_SIZE = 181;
    @Nullable
    public static GuiForesterBook guiScreen;
    protected final IForesterBook book;
    final ElementManager<GuiForesterBook> elementManager;
    protected int guiLeft;
    protected int guiTop;

    protected GuiForesterBook(IForesterBook book) {
        this.book = book;
        GuiForesterBook.setGuiScreen(this);
        this.elementManager = new ElementManager<GuiForesterBook>(this);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.guiLeft = (this.field_146294_l - 256) / 2;
        this.guiTop = (this.field_146295_m - 181) / 2;
        this.elementManager.init(this.guiLeft, this.guiTop);
        this.field_146292_n.clear();
        if (this.hasButtons()) {
            GuiButtonPage leftButton = (GuiButtonPage)this.func_189646_b(new GuiButtonPage(0, this.guiLeft + 24, this.guiTop + 181 - 20, true));
            GuiButtonPage rightButton = (GuiButtonPage)this.func_189646_b(new GuiButtonPage(1, this.guiLeft + 256 - 44, this.guiTop + 181 - 20, false));
            GuiButtonBack backButton = (GuiButtonBack)this.func_189646_b(new GuiButtonBack(2, this.guiLeft + 128 - 12, this.guiTop + 181 - 20));
            this.initButtons(leftButton, rightButton, backButton);
        }
    }

    protected boolean hasButtons() {
        return true;
    }

    protected void initButtons(GuiButtonPage leftButton, GuiButtonPage rightButton, GuiButtonBack backButton) {
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        TextureManager manager = this.field_146297_k.field_71446_o;
        manager.func_110577_a(TEXTURE);
        this.func_73729_b(this.guiLeft, this.guiTop, 0, 0, 256, 181);
        super.func_73863_a(mouseX, mouseY, partialTicks);
        boolean unicode = this.field_146289_q.func_82883_a();
        this.field_146289_q.func_78264_a(true);
        this.func_73732_a(this.field_146289_q, TextFormatting.UNDERLINE + this.getTitle(), this.guiLeft + 16 + 52, this.guiTop + 12, 0xD3D3D3);
        this.drawText();
        this.field_146289_q.func_78264_a(unicode);
        this.elementManager.draw(mouseX, mouseY);
        InventoryPlayer playerInv = this.field_146297_k.field_71439_g.field_71071_by;
        if (playerInv.func_70445_o().func_190926_b()) {
            GuiUtil.drawToolTips(this, this.field_146292_n, mouseX, mouseY);
            this.elementManager.drawTooltip(mouseX, mouseY);
            List<String> tooltip = this.getTooltip(mouseX, mouseY);
            if (!tooltip.isEmpty()) {
                ScaledResolution scaledresolution = new ScaledResolution(this.field_146297_k);
                GuiUtils.drawHoveringText(tooltip, (int)mouseX, (int)mouseY, (int)scaledresolution.func_78326_a(), (int)scaledresolution.func_78328_b(), (int)-1, (FontRenderer)this.field_146289_q);
            }
        }
    }

    protected void drawText() {
    }

    protected List<String> getTooltip(int mouseX, int mouseY) {
        return Collections.emptyList();
    }

    protected abstract String getTitle();

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.elementManager.keyTyped(typedChar, keyCode)) {
            return;
        }
        super.func_73869_a(typedChar, keyCode);
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.elementManager.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void func_146273_a(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        super.func_146273_a(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
        this.elementManager.mouseClickMove(mouseX, mouseY, clickedMouseButton);
    }

    protected void func_146286_b(int mouseX, int mouseY, int state) {
        super.func_146286_b(mouseX, mouseY, state);
        this.elementManager.mouseReleased(mouseX, mouseY, state);
    }

    @Override
    public int getGuiLeft() {
        return this.guiLeft;
    }

    @Override
    public int getGuiTop() {
        return this.guiTop;
    }

    @Override
    public int getSizeX() {
        return 256;
    }

    @Override
    public int getSizeY() {
        return 181;
    }

    @Override
    public Minecraft getMC() {
        return this.field_146297_k;
    }

    public static void setGuiScreen(@Nullable GuiForesterBook guiScreen) {
        GuiForesterBook.guiScreen = guiScreen;
    }
}

