/*
 * Decompiled with CFR 0.152.
 */
package forestry.book.gui.elements;

import forestry.api.gui.GuiElementAlignment;
import forestry.book.gui.GuiForesterBook;
import forestry.core.gui.Drawable;
import forestry.core.gui.elements.ButtonElement;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.gui.elements.layouts.ElementGroup;
import forestry.core.gui.elements.layouts.PaneLayout;
import javax.annotation.Nullable;
import net.minecraft.util.text.TextFormatting;

public abstract class SelectionElement<R>
extends PaneLayout {
    private static final Drawable CRAFTING_COUNT = new Drawable(GuiForesterBook.TEXTURE, 104, 181, 34, 14);
    private static final Drawable RIGHT_BUTTON = new Drawable(GuiForesterBook.TEXTURE, 138, 181, 10, 9);
    private static final Drawable LEFT_BUTTON = new Drawable(GuiForesterBook.TEXTURE, 148, 181, 10, 9);
    private int index = -1;
    @Nullable
    protected final ButtonElement leftButton;
    @Nullable
    protected final ButtonElement rightButton;
    @Nullable
    protected final ElementGroup text;
    protected final ElementGroup selectedElement;
    protected final R[] recipes;

    protected SelectionElement(int xPos, int yPos, int width, int height, R[] recipes) {
        this(xPos, yPos, width, height, recipes, 0);
    }

    protected SelectionElement(int xPos, int yPos, int width, int height, R[] recipes, int yOffset) {
        super(xPos, yPos, width, height + (recipes.length > 1 ? 16 : 0));
        this.recipes = recipes;
        if (recipes.length > 1) {
            this.drawable(0, 0, CRAFTING_COUNT).setAlign(GuiElementAlignment.BOTTOM_CENTER);
            this.text = this.panel(width, this.height);
            this.leftButton = this.add(new ButtonElement(-27, -2, LEFT_BUTTON, e -> this.setIndex(this.index - 1)));
            this.leftButton.setAlign(GuiElementAlignment.BOTTOM_CENTER);
            this.rightButton = this.add(new ButtonElement(27, -2, RIGHT_BUTTON, e -> this.setIndex(this.index + 1)));
            this.rightButton.setAlign(GuiElementAlignment.BOTTOM_CENTER);
        } else {
            this.text = null;
            this.leftButton = null;
            this.rightButton = null;
        }
        this.selectedElement = GuiElementFactory.INSTANCE.createPanel(0, 2, width, this.height);
    }

    protected final void setIndex(int index) {
        if (index == this.index || index >= this.recipes.length || index < 0) {
            return;
        }
        this.index = index;
        this.selectedElement.clear();
        this.onIndexUpdate(index, this.recipes[index]);
        if (this.text != null) {
            this.text.clear();
            this.text.text(TextFormatting.BLACK.toString() + (index + 1) + "/" + this.recipes.length, GuiElementAlignment.BOTTOM_CENTER, 0).setYPosition(2);
        }
        if (this.leftButton != null) {
            this.leftButton.setEnabled(index > 0);
        }
        if (this.rightButton != null) {
            this.rightButton.setEnabled(index < this.recipes.length - 1);
        }
    }

    protected abstract void onIndexUpdate(int var1, R var2);
}

