/*
 * Decompiled with CFR 0.152.
 */
package forestry.book.gui.elements;

import forestry.api.recipes.ICarpenterRecipe;
import forestry.api.recipes.IDescriptiveRecipe;
import forestry.book.gui.elements.SelectionElement;
import forestry.core.gui.Drawable;
import forestry.core.gui.elements.IngredientElement;
import forestry.core.gui.elements.TankElement;
import forestry.factory.recipes.CarpenterRecipeManager;
import java.util.Collection;
import java.util.stream.Stream;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidTankInfo;

public class CarpenterElement
extends SelectionElement<ICarpenterRecipe> {
    private static final ResourceLocation BOOK_CRAFTING_TEXTURE = new ResourceLocation("forestry", "textures/gui/almanac/crafting.png");
    private static final Drawable CARPENTER_BACKGROUND = new Drawable(BOOK_CRAFTING_TEXTURE, 0, 0, 108, 60);
    private static final Drawable CARPENTER_TANK_OVERLAY = new Drawable(BOOK_CRAFTING_TEXTURE, 109, 1, 16, 58);

    public CarpenterElement(int xPos, int yPos, ItemStack stack) {
        this(0, 0, new ItemStack[]{stack});
    }

    public CarpenterElement(int xPos, int yPos, ItemStack[] stacks) {
        this(0, 0, (ICarpenterRecipe[])Stream.of(stacks).map(CarpenterRecipeManager::getRecipes).flatMap(Collection::stream).toArray(ICarpenterRecipe[]::new));
    }

    public CarpenterElement(int xPos, int yPos, ICarpenterRecipe[] recipes) {
        super(xPos, yPos, 108, 62, recipes, 2);
        this.drawable(0, 2, CARPENTER_BACKGROUND);
        this.add(this.selectedElement);
        this.setIndex(0);
    }

    @Override
    protected void onIndexUpdate(int index, ICarpenterRecipe recipe) {
        this.selectedElement.add(new TankElement(91, 1, null, () -> new FluidTankInfo(recipe.getFluidResource(), 10000), CARPENTER_TANK_OVERLAY));
        IDescriptiveRecipe gridRecipe = recipe.getCraftingGridRecipe();
        NonNullList<NonNullList<ItemStack>> ingredients = gridRecipe.getRawIngredients();
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                int ingredientIndex = y * 3 + x;
                if (ingredientIndex >= ingredients.size()) continue;
                NonNullList items = (NonNullList)ingredients.get(ingredientIndex);
                this.selectedElement.add(new IngredientElement(1 + x * 19, 3 + y * 19, Ingredient.func_193369_a((ItemStack[])((ItemStack[])items.toArray((Object[])new ItemStack[items.size()])))));
            }
        }
        this.selectedElement.item(71, 41, gridRecipe.getOutput());
    }
}

