package forestry.core.utils;

import javax.annotation.Nullable;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.IResource;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.util.ResourceLocation;

public class ResourceUtil {
	private ResourceUtil() {
	}

	@Nullable
	public static IResource getResource(ResourceLocation location) {
		try {
			IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
			return resourceManager.func_110536_a(location);
		} catch (IOException e) {
			return null;
		}
	}

	public static List<IResource> getResources(ResourceLocation location) {
		try {
			IResourceManager resourceManager = Minecraft.func_71410_x().func_110442_L();
			return resourceManager.func_135056_b(location);
		} catch (IOException e) {
			return Collections.emptyList();
		}
	}

	public static boolean resourceExists(ResourceLocation location) {
		return getResource(location) != null;
	}
}
