package forestry.book.gui.elements;

import java.util.ArrayList;
import java.util.List;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.TextFormatting;

import forestry.book.data.TextData;
import forestry.core.gui.elements.GuiElement;

public class TextDataElement extends GuiElement {

	private final List<TextData> textElements = new ArrayList<>();

	public TextDataElement(int xPos, int yPos, int width, int height) {
		super(xPos, yPos, width, height);
	}

	@Override
	public int getHeight() {
		if (height >= 0) {
			return height;
		}
		FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
		boolean unicode = fontRenderer.func_82883_a();
		fontRenderer.func_78264_a(true);
		boolean lastEmpty = false;
		for (TextData data : textElements) {
			if (data.text.equals("\n")) {
				if (lastEmpty) {
					height += fontRenderer.field_78288_b;
				}
				lastEmpty = true;
				continue;
			}
			lastEmpty = false;

			if (data.paragraph) {
				height += fontRenderer.field_78288_b * 1.6D;
			}

			String modifiers = "";

			modifiers += TextFormatting.func_96300_b(data.color);

			if (data.bold) {
				modifiers += TextFormatting.BOLD;
			}
			if (data.italic) {
				modifiers += TextFormatting.ITALIC;
			}
			if (data.underlined) {
				modifiers += TextFormatting.UNDERLINE;
			}
			if (data.strikethrough) {
				modifiers += TextFormatting.STRIKETHROUGH;
			}
			if (data.obfuscated) {
				modifiers += TextFormatting.OBFUSCATED;
			}
			height += fontRenderer.func_78267_b(modifiers + data.text, width);
		}
		fontRenderer.func_78264_a(unicode);
		return height;
	}

	@Override
	public void drawElement(int mouseX, int mouseY) {
		FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
		boolean unicode = fontRenderer.func_82883_a();
		fontRenderer.func_78264_a(true);
		int x = 0;
		int y = 0;
		for (TextData data : textElements) {
			if (data.text.equals("\n")) {
				x = 0;
				y += fontRenderer.field_78288_b;
				continue;
			}

			if (data.paragraph) {
				x = 0;
				y += fontRenderer.field_78288_b * 1.6D;
			}

			String text = getFormattedString(data);
			List<String> split = fontRenderer.func_78271_c(text, width);
			for (int i = 0; i < split.size(); i++) {
				String s = split.get(i);
				int textLength = fontRenderer.func_175065_a(s, x, y, 0, data.dropshadow);
				if (i == split.size() - 1) {
					x += textLength;
				} else {
					y += fontRenderer.field_78288_b;
				}
			}
		}
		fontRenderer.func_78264_a(unicode);
	}

	private String getFormattedString(TextData data) {
		StringBuilder modifiers = new StringBuilder();

		modifiers.append(TextFormatting.func_96300_b(data.color));

		if (data.bold) {
			modifiers.append(TextFormatting.BOLD);
		}
		if (data.italic) {
			modifiers.append(TextFormatting.ITALIC);
		}
		if (data.underlined) {
			modifiers.append(TextFormatting.UNDERLINE);
		}
		if (data.strikethrough) {
			modifiers.append(TextFormatting.STRIKETHROUGH);
		}
		if (data.obfuscated) {
			modifiers.append(TextFormatting.OBFUSCATED);
		}
		modifiers.append(data.text);
		return modifiers.toString();
	}

	public void addData(TextData textData) {
		textElements.add(textData);
		height = -1;
	}
}
