package forestry.book.gui.buttons;

import java.util.Collections;
import java.util.List;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.texture.TextureManager;

import forestry.api.book.IBookEntry;
import forestry.book.gui.GuiForesterBook;
import forestry.core.gui.GuiUtil;

public class GuiButtonSubEntry extends GuiButton {
	public final IBookEntry selectedEntry;
	public final IBookEntry subEntry;

	public GuiButtonSubEntry(int buttonId, int x, int y, IBookEntry subEntry, IBookEntry selectedEntry) {
		super(buttonId, x, y, 24, 21, "");
		this.subEntry = subEntry;
		this.selectedEntry = selectedEntry;
	}

	@Override
	public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
		if (!field_146125_m) {
			return;
		}
		boolean active = subEntry == selectedEntry;
		TextureManager manager = mc.field_71446_o;
		manager.func_110577_a(GuiForesterBook.TEXTURE);
		GlStateManager.func_179094_E();
		GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);

		func_73729_b(field_146128_h, field_146129_i, 48 + (active ? 24 : 0), 201, 24, 21);

		GlStateManager.func_179109_b(field_146128_h + 8.0F, field_146129_i + 4.0F, field_73735_i);
		GlStateManager.func_179152_a(0.85F, 0.85F, 0.85F);
		RenderHelper.func_74520_c();
		GlStateManager.func_179091_B();

		GuiUtil.drawItemStack(mc.field_71466_p, subEntry.getStack(), 0, 0);

		RenderHelper.func_74518_a();
		GlStateManager.func_179121_F();
	}

	public List<String> getToolTip() {
		return Collections.singletonList(subEntry.getTitle());
	}

	public boolean isMouseOver(int mouseX, int mouseY) {
		return mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
	}
}
