package forestry.book.gui;

import com.google.common.collect.ImmutableList;

import javax.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;

import net.minecraft.client.gui.GuiButton;

import forestry.api.book.IBookCategory;
import forestry.api.book.IBookEntry;
import forestry.api.book.IForesterBook;
import forestry.api.gui.IElementGroup;
import forestry.api.gui.IGuiElement;
import forestry.book.gui.buttons.GuiButtonBack;
import forestry.book.gui.buttons.GuiButtonPage;
import forestry.book.gui.buttons.GuiButtonSubEntry;
import forestry.core.gui.elements.layouts.ElementGroup;

public class GuiForestryBookPages extends GuiForesterBook {
	private final IBookCategory category;
	private final IBookEntry entry;
	@Nullable
	private final IBookEntry parent;
	private final List<GuiButtonSubEntry> subButtons = new ArrayList<>();
	private List<IGuiElement> pages;
	private int pageIndex = 0;
	private IElementGroup leftPage;
	private IElementGroup rightPage;
	private int nextPage = -1;
	private int lastPage = -1;

	public GuiForestryBookPages(IForesterBook book, IBookCategory category, IBookEntry entry, @Nullable IBookEntry parent) {
		super(book);
		this.category = category;
		this.entry = entry;
		this.parent = parent;
		ElementGroup group = elementManager.group();
		leftPage = group.panel(LEFT_PAGE_START_X, LEFT_PAGE_START_Y, PAGE_WIDTH, PAGE_HEIGHT);
		rightPage = group.panel(RIGHT_PAGE_START_X, RIGHT_PAGE_START_Y, PAGE_WIDTH, PAGE_HEIGHT);
		pages = ImmutableList.copyOf(entry.getPageFactory().load(entry, GuiForesterBook.PAGE_HEIGHT - 13, GuiForesterBook.PAGE_HEIGHT, GuiForesterBook.PAGE_WIDTH));
		setPages(0);
	}

	private void setPages(int index) {
		leftPage.clear();
		rightPage.clear();
		if (index < 0 || index >= pages.size()) {
			pageIndex = 0;
			return;
		}
		leftPage.add(pages.get(index));
		if (pages.size() > index + 1) {
			rightPage.add(pages.get(index + 1));
		}
		pageIndex = index;
	}

	public void switchPage(int page) {
		if (page % 2 == 1) {
			page -= 1;
		}
		this.nextPage = page;
	}

	@Override
	public void func_73876_c() {
		super.func_73876_c();
		if (nextPage >= 0) {
			lastPage = pageIndex;
			setPages(nextPage);
			nextPage = -1;
			func_73866_w_();
		}
	}

	@Override
	protected void initButtons(GuiButtonPage leftButton, GuiButtonPage rightButton, GuiButtonBack backButton) {
		leftButton.field_146125_m = pageIndex > 0;
		rightButton.field_146125_m = pages.size() > (pageIndex + 2);
	}

	@Override
	public void func_73866_w_() {
		super.func_73866_w_();
		IBookEntry firstEntry = parent != null ? parent : entry;
		subButtons.add(func_189646_b(new GuiButtonSubEntry(field_146292_n.size(), guiLeft + -24, guiTop + 12, firstEntry, entry)));
		IBookEntry[] subEntries = firstEntry.getSubEntries();
		for (int i = 0; i < subEntries.length; i++) {
			IBookEntry subEntry = subEntries[i];
			subButtons.add(func_189646_b(new GuiButtonSubEntry(field_146292_n.size(), guiLeft + -24, guiTop + 12 + ((i + 1) * 22), subEntry, entry)));
		}
	}

	@Override
	protected List<String> getTooltip(int mouseX, int mouseY) {
		List<String> tooltip = new LinkedList<>();
		for (GuiButtonSubEntry subEntry : subButtons) {
			if (subEntry.isMouseOver(mouseX, mouseY)) {
				tooltip.addAll(subEntry.getToolTip());
			}
		}
		return tooltip;
	}

	@Override
	protected String getTitle() {
		return entry.getTitle();
	}

	@Override
	protected void func_146284_a(GuiButton button) throws IOException {
		if (button instanceof GuiButtonPage) {
			GuiButtonPage pageButton = (GuiButtonPage) button;
			if (pageButton.left) {
				setPages(pageIndex - 2);
			} else {
				setPages(pageIndex + 2);
			}
			func_73866_w_();
			if (lastPage >= 0) {
				lastPage = -1;
			}
		} else if (button instanceof GuiButtonSubEntry) {
			GuiButtonSubEntry subEntry = (GuiButtonSubEntry) button;
			field_146297_k.func_147108_a(new GuiForestryBookPages(book, category, subEntry.subEntry, parent != null ? parent : entry));
		} else if (button instanceof GuiButtonBack || pages.isEmpty()) {
			if (lastPage >= 0) {
				setPages(lastPage);
				lastPage = -1;
				func_73866_w_();
			} else {
				displayEntries();
			}
		}
	}

	private void displayEntries() {
		field_146297_k.func_147108_a(new GuiForestryBookEntries(book, category));
	}
}
