/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics.analyzer;

import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.gui.GuiElementAlignment;
import forestry.api.gui.IElementGenetic;
import forestry.api.gui.IElementLayoutHelper;
import forestry.core.genetics.analyzer.DatabaseTab;
import forestry.core.gui.elements.GuiElementFactory;
import forestry.core.utils.Translator;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;

public class MutationsTab
extends DatabaseTab {
    public MutationsTab(Supplier<ItemStack> stackSupplier) {
        super("mutations", stackSupplier);
    }

    @Override
    public void createElements(IElementGenetic container, IIndividual individual, ItemStack itemStack) {
        IGenome genome = individual.getGenome();
        ISpeciesRoot speciesRoot = genome.getSpeciesRoot();
        IAlleleSpecies species = genome.getPrimary();
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker(player.field_70170_p, player.func_146103_bH());
        IElementLayoutHelper groupHelper = container.layoutHelper((x, y) -> GuiElementFactory.INSTANCE.createHorizontal(x + 1, y, 16), 100, 0);
        Collection<? extends IMutation> mutations = this.getValidMutations(speciesRoot.getCombinations(species));
        if (!mutations.isEmpty()) {
            container.text(TextFormatting.UNDERLINE + Translator.translateToLocal("for.gui.database.mutations.further"), GuiElementAlignment.TOP_CENTER);
            mutations.forEach(mutation -> groupHelper.add(GuiElementFactory.INSTANCE.createMutation(0, 0, 50, 16, (IMutation)mutation, species, breedingTracker)));
            groupHelper.finish(true);
        }
        if ((mutations = this.getValidMutations(speciesRoot.getResultantMutations(species))).isEmpty()) {
            return;
        }
        container.text(TextFormatting.UNDERLINE + Translator.translateToLocal("for.gui.database.mutations.resultant"), GuiElementAlignment.TOP_CENTER);
        mutations.forEach(mutation -> groupHelper.add(GuiElementFactory.INSTANCE.createMutationResultant(0, 0, 50, 16, (IMutation)mutation, breedingTracker)));
        groupHelper.finish(true);
    }

    private Collection<? extends IMutation> getValidMutations(List<? extends IMutation> mutations) {
        mutations.removeIf(IMutation::isSecret);
        return mutations;
    }
}

