/*
 * Decompiled with CFR 0.152.
 */
package forestry.book.gui;

import com.google.common.collect.ImmutableList;
import forestry.api.book.IBookCategory;
import forestry.api.book.IBookEntry;
import forestry.api.book.IForesterBook;
import forestry.api.gui.IElementGroup;
import forestry.api.gui.IGuiElement;
import forestry.book.gui.GuiForesterBook;
import forestry.book.gui.GuiForestryBookEntries;
import forestry.book.gui.buttons.GuiButtonBack;
import forestry.book.gui.buttons.GuiButtonPage;
import forestry.book.gui.buttons.GuiButtonSubEntry;
import forestry.core.gui.elements.layouts.ElementGroup;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;

public class GuiForestryBookPages
extends GuiForesterBook {
    private final IBookCategory category;
    private final IBookEntry entry;
    @Nullable
    private final IBookEntry parent;
    private final List<GuiButtonSubEntry> subButtons = new ArrayList<GuiButtonSubEntry>();
    private List<IGuiElement> pages;
    private int pageIndex = 0;
    private IElementGroup leftPage;
    private IElementGroup rightPage;
    private int nextPage = -1;
    private int lastPage = -1;

    public GuiForestryBookPages(IForesterBook book, IBookCategory category, IBookEntry entry, @Nullable IBookEntry parent) {
        super(book);
        this.category = category;
        this.entry = entry;
        this.parent = parent;
        ElementGroup group = this.elementManager.group();
        this.leftPage = group.panel(16, 25, 108, 155);
        this.rightPage = group.panel(132, 12, 108, 155);
        this.pages = ImmutableList.copyOf(entry.getPageFactory().load(entry, 142, 155, 108));
        this.setPages(0);
    }

    private void setPages(int index) {
        this.leftPage.clear();
        this.rightPage.clear();
        if (index < 0 || index >= this.pages.size()) {
            this.pageIndex = 0;
            return;
        }
        this.leftPage.add(this.pages.get(index));
        if (this.pages.size() > index + 1) {
            this.rightPage.add(this.pages.get(index + 1));
        }
        this.pageIndex = index;
    }

    public void switchPage(int page) {
        if (page % 2 == 1) {
            --page;
        }
        this.nextPage = page;
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (this.nextPage >= 0) {
            this.lastPage = this.pageIndex;
            this.setPages(this.nextPage);
            this.nextPage = -1;
            this.func_73866_w_();
        }
    }

    @Override
    protected void initButtons(GuiButtonPage leftButton, GuiButtonPage rightButton, GuiButtonBack backButton) {
        leftButton.field_146125_m = this.pageIndex > 0;
        rightButton.field_146125_m = this.pages.size() > this.pageIndex + 2;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        IBookEntry firstEntry = this.parent != null ? this.parent : this.entry;
        this.subButtons.add((GuiButtonSubEntry)this.func_189646_b(new GuiButtonSubEntry(this.field_146292_n.size(), this.guiLeft + -24, this.guiTop + 12, firstEntry, this.entry)));
        IBookEntry[] subEntries = firstEntry.getSubEntries();
        for (int i = 0; i < subEntries.length; ++i) {
            IBookEntry subEntry = subEntries[i];
            this.subButtons.add((GuiButtonSubEntry)this.func_189646_b(new GuiButtonSubEntry(this.field_146292_n.size(), this.guiLeft + -24, this.guiTop + 12 + (i + 1) * 22, subEntry, this.entry)));
        }
    }

    @Override
    protected List<String> getTooltip(int mouseX, int mouseY) {
        LinkedList<String> tooltip = new LinkedList<String>();
        for (GuiButtonSubEntry subEntry : this.subButtons) {
            if (!subEntry.isMouseOver(mouseX, mouseY)) continue;
            tooltip.addAll(subEntry.getToolTip());
        }
        return tooltip;
    }

    @Override
    protected String getTitle() {
        return this.entry.getTitle();
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button instanceof GuiButtonPage) {
            GuiButtonPage pageButton = (GuiButtonPage)button;
            if (pageButton.left) {
                this.setPages(this.pageIndex - 2);
            } else {
                this.setPages(this.pageIndex + 2);
            }
            this.func_73866_w_();
            if (this.lastPage >= 0) {
                this.lastPage = -1;
            }
        } else if (button instanceof GuiButtonSubEntry) {
            GuiButtonSubEntry subEntry = (GuiButtonSubEntry)button;
            this.field_146297_k.func_147108_a((GuiScreen)new GuiForestryBookPages(this.book, this.category, subEntry.subEntry, this.parent != null ? this.parent : this.entry));
        } else if (button instanceof GuiButtonBack || this.pages.isEmpty()) {
            if (this.lastPage >= 0) {
                this.setPages(this.lastPage);
                this.lastPage = -1;
                this.func_73866_w_();
            } else {
                this.displayEntries();
            }
        }
    }

    private void displayEntries() {
        this.field_146297_k.func_147108_a((GuiScreen)new GuiForestryBookEntries(this.book, this.category));
    }
}

