/*
 * Decompiled with CFR 0.152.
 */
package forestry.book;

import com.google.common.base.Preconditions;
import forestry.api.book.BookManager;
import forestry.api.modules.ForestryModule;
import forestry.book.BookLoader;
import forestry.book.EventHandlerBook;
import forestry.book.items.ItemRegistryBook;
import forestry.book.proxy.ProxyBook;
import forestry.core.recipes.RecipeUtil;
import forestry.lepidopterology.ModuleLepidopterology;
import forestry.lepidopterology.items.ItemRegistryLepidopterology;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleHelper;
import forestry.modules.ModuleManager;
import javax.annotation.Nullable;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.SidedProxy;

@ForestryModule(containerID="forestry", moduleID="book", name="Book", author="Nedelosk", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.book.description")
public class ModuleBook
extends BlankForestryModule {
    @SidedProxy(clientSide="forestry.book.proxy.ProxyBookClient", serverSide="forestry.book.proxy.ProxyBook")
    public static ProxyBook proxy;
    @Nullable
    private static ItemRegistryBook items;

    public static ItemRegistryBook getItems() {
        Preconditions.checkState((items != null ? 1 : 0) != 0);
        return items;
    }

    @Override
    public void setupAPI() {
        BookManager.loader = BookLoader.INSTANCE;
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryBook();
    }

    @Override
    public void preInit() {
        proxy.preInit();
        MinecraftForge.EVENT_BUS.register((Object)new EventHandlerBook());
    }

    @Override
    public void registerRecipes() {
        RecipeUtil.addShapelessRecipe("book_honey", new ItemStack((Item)ModuleBook.getItems().book), Items.field_151122_aG, "dropHoney");
        RecipeUtil.addShapelessRecipe("book_tree", new ItemStack((Item)ModuleBook.getItems().book), Items.field_151122_aG, "treeSapling");
        if (ModuleHelper.isEnabled("lepidopterology")) {
            ItemRegistryLepidopterology itemsLepi = ModuleLepidopterology.getItems();
            RecipeUtil.addShapelessRecipe("book_butterfly", new ItemStack((Item)ModuleBook.getItems().book), Items.field_151122_aG, itemsLepi.butterflyGE);
        }
    }

    @Override
    public void postInit() {
        ModuleManager.getInternalHandler().runBookInit();
    }
}

