/*
 * Decompiled with CFR 0.152.
 */
package forestry.arboriculture;

import com.google.common.base.Preconditions;
import forestry.api.arboriculture.EnumForestryWoodType;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.EnumVanillaWoodType;
import forestry.api.arboriculture.IAlleleFruit;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.IWoodType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.arboriculture.WoodBlockKind;
import forestry.api.core.ForestryAPI;
import forestry.api.core.IArmorNaturalist;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IBlockTranslator;
import forestry.api.genetics.IItemTranslator;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.arboriculture.ArboricultureFilterRuleType;
import forestry.arboriculture.VillagerArboristTrades;
import forestry.arboriculture.WoodAccess;
import forestry.arboriculture.blocks.BlockArbLog;
import forestry.arboriculture.blocks.BlockDefaultLeaves;
import forestry.arboriculture.blocks.BlockForestryLeaves;
import forestry.arboriculture.blocks.BlockRegistryArboriculture;
import forestry.arboriculture.capabilities.ArmorNaturalist;
import forestry.arboriculture.commands.CommandTree;
import forestry.arboriculture.genetics.TreeBranchDefinition;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.arboriculture.genetics.TreeFactory;
import forestry.arboriculture.genetics.TreeMutationFactory;
import forestry.arboriculture.genetics.TreeRoot;
import forestry.arboriculture.genetics.TreekeepingMode;
import forestry.arboriculture.genetics.alleles.AlleleFruits;
import forestry.arboriculture.genetics.alleles.AlleleLeafEffects;
import forestry.arboriculture.items.ItemGrafter;
import forestry.arboriculture.items.ItemRegistryArboriculture;
import forestry.arboriculture.models.TextureLeaves;
import forestry.arboriculture.models.WoodTextureManager;
import forestry.arboriculture.network.PacketRegistryArboriculture;
import forestry.arboriculture.proxy.ProxyArboriculture;
import forestry.arboriculture.proxy.ProxyArboricultureClient;
import forestry.arboriculture.tiles.TileFruitPod;
import forestry.arboriculture.tiles.TileLeaves;
import forestry.arboriculture.tiles.TileSapling;
import forestry.arboriculture.worldgen.TreeDecorator;
import forestry.core.ModuleCore;
import forestry.core.capabilities.NullStorage;
import forestry.core.config.Config;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemFruit;
import forestry.core.items.ItemRegistryCore;
import forestry.core.network.IPacketRegistry;
import forestry.core.recipes.RecipeUtil;
import forestry.core.render.TextureManagerForestry;
import forestry.core.utils.IMCUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.VillagerTradeLists;
import forestry.modules.BlankForestryModule;
import forestry.modules.ModuleHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLeaves;
import net.minecraft.block.BlockNewLeaf;
import net.minecraft.block.BlockOldLeaf;
import net.minecraft.block.BlockPlanks;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

@ForestryModule(containerID="forestry", moduleID="arboriculture", name="Arboriculture", author="Binnie & SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.arboriculture.description", lootTable="arboriculture")
public class ModuleArboriculture
extends BlankForestryModule {
    @SidedProxy(clientSide="forestry.arboriculture.proxy.ProxyArboricultureClient", serverSide="forestry.arboriculture.proxy.ProxyArboriculture")
    public static ProxyArboriculture proxy;
    public static String treekeepingMode;
    public static final List<Block> validFences;
    @Nullable
    private static ItemRegistryArboriculture items;
    @Nullable
    private static BlockRegistryArboriculture blocks;
    @Nullable
    public static VillagerRegistry.VillagerProfession villagerArborist;

    public static ItemRegistryArboriculture getItems() {
        Preconditions.checkState((items != null ? 1 : 0) != 0);
        return items;
    }

    public static BlockRegistryArboriculture getBlocks() {
        Preconditions.checkState((blocks != null ? 1 : 0) != 0);
        return blocks;
    }

    @Override
    public void setupAPI() {
        TreeManager.treeFactory = new TreeFactory();
        TreeManager.treeMutationFactory = new TreeMutationFactory();
        TreeManager.woodAccess = WoodAccess.getInstance();
        TreeManager.treeRoot = new TreeRoot();
        AlleleManager.alleleRegistry.registerSpeciesRoot(TreeManager.treeRoot);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.easy);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.normal);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.hard);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.hardcore);
        TreeManager.treeRoot.registerTreekeepingMode(TreekeepingMode.insane);
        CapabilityManager.INSTANCE.register(IArmorNaturalist.class, new NullStorage(), () -> ArmorNaturalist.INSTANCE);
    }

    @Override
    public void disabledSetupAPI() {
        TreeManager.woodAccess = WoodAccess.getInstance();
        CapabilityManager.INSTANCE.register(IArmorNaturalist.class, new NullStorage(), () -> ArmorNaturalist.INSTANCE);
    }

    @Override
    public void registerItemsAndBlocks() {
        items = new ItemRegistryArboriculture();
        blocks = new BlockRegistryArboriculture();
    }

    @Override
    public void preInit() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        if (Config.generateTrees) {
            MinecraftForge.TERRAIN_GEN_BUS.register((Object)new TreeDecorator());
        }
        BlockRegistryArboriculture blocks = ModuleArboriculture.getBlocks();
        WoodAccess woodAccess = WoodAccess.getInstance();
        woodAccess.registerLogs(blocks.logs);
        woodAccess.registerPlanks(blocks.planks);
        woodAccess.registerSlabs(blocks.slabs);
        woodAccess.registerFences(blocks.fences);
        woodAccess.registerFenceGates(blocks.fenceGates);
        woodAccess.registerStairs(blocks.stairs);
        woodAccess.registerDoors(blocks.doors);
        woodAccess.registerLogs(blocks.logsFireproof);
        woodAccess.registerPlanks(blocks.planksFireproof);
        woodAccess.registerSlabs(blocks.slabsFireproof);
        woodAccess.registerFences(blocks.fencesFireproof);
        woodAccess.registerFenceGates(blocks.fenceGatesFireproof);
        woodAccess.registerStairs(blocks.stairsFireproof);
        woodAccess.registerLogs(blocks.logsVanillaFireproof);
        woodAccess.registerPlanks(blocks.planksVanillaFireproof);
        woodAccess.registerSlabs(blocks.slabsVanillaFireproof);
        woodAccess.registerFences(blocks.fencesVanillaFireproof);
        woodAccess.registerFenceGates(blocks.fenceGatesVanillaFireproof);
        woodAccess.registerStairs(blocks.stairsVanillaFireproof);
        proxy.initializeModels();
        ModuleCore.rootCommand.addChildCommand(new CommandTree());
        if (ModuleHelper.isEnabled("sorting")) {
            ArboricultureFilterRuleType.init();
        }
    }

    @Override
    public void addLootPoolNames(Set<String> lootPoolNames) {
        lootPoolNames.add("forestry_arboriculture_items");
    }

    @Override
    public void doInit() {
        ModuleArboriculture.registerAlleles();
        TreeDefinition.initTrees();
        ModuleArboriculture.registerErsatzGenomes();
        GameRegistry.registerTileEntity(TileSapling.class, (String)"forestry.Sapling");
        GameRegistry.registerTileEntity(TileLeaves.class, (String)"forestry.Leaves");
        GameRegistry.registerTileEntity(TileFruitPod.class, (String)"forestry.Pods");
        ItemRegistryArboriculture items = ModuleArboriculture.getItems();
        BlockRegistryArboriculture blocks = ModuleArboriculture.getBlocks();
        blocks.treeChest.init();
        if (Config.enableVillagers) {
            villagerArborist = new VillagerRegistry.VillagerProfession("forestry:arborist", "forestry:textures/entity/lumberjack.png", "forestry:textures/entity/zombie_lumberjack.png");
            ForgeRegistries.VILLAGER_PROFESSIONS.register((IForgeRegistryEntry)villagerArborist);
            VillagerRegistry.VillagerCareer arboristCareer = new VillagerRegistry.VillagerCareer(villagerArborist, "arborist");
            arboristCareer.addTrade(1, new EntityVillager.ITradeList[]{new VillagerArboristTrades.GivePlanksForEmeralds(new EntityVillager.PriceInfo(1, 1), new EntityVillager.PriceInfo(10, 32)), new VillagerArboristTrades.GivePollenForEmeralds(new EntityVillager.PriceInfo(1, 1), new EntityVillager.PriceInfo(1, 3), EnumGermlingType.SAPLING, 4)});
            arboristCareer.addTrade(2, new EntityVillager.ITradeList[]{new VillagerArboristTrades.GivePlanksForEmeralds(new EntityVillager.PriceInfo(1, 1), new EntityVillager.PriceInfo(10, 32)), new VillagerTradeLists.GiveItemForEmeralds(new EntityVillager.PriceInfo(1, 4), items.grafterProven.getItemStack(), new EntityVillager.PriceInfo(1, 1)), new VillagerArboristTrades.GivePollenForEmeralds(new EntityVillager.PriceInfo(2, 3), new EntityVillager.PriceInfo(1, 1), EnumGermlingType.POLLEN, 6)});
            arboristCareer.addTrade(3, new EntityVillager.ITradeList[]{new VillagerArboristTrades.GiveLogsForEmeralds(new EntityVillager.PriceInfo(2, 5), new EntityVillager.PriceInfo(6, 18)), new VillagerArboristTrades.GiveLogsForEmeralds(new EntityVillager.PriceInfo(2, 5), new EntityVillager.PriceInfo(6, 18))});
            arboristCareer.addTrade(4, new EntityVillager.ITradeList[]{new VillagerArboristTrades.GivePollenForEmeralds(new EntityVillager.PriceInfo(5, 20), new EntityVillager.PriceInfo(1, 1), EnumGermlingType.POLLEN, 10), new VillagerArboristTrades.GivePollenForEmeralds(new EntityVillager.PriceInfo(5, 20), new EntityVillager.PriceInfo(1, 1), EnumGermlingType.SAPLING, 10)});
        }
    }

    @Override
    public void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        crateRegistry.registerCrate(ItemFruit.EnumFruit.CHERRY.getStack());
        crateRegistry.registerCrate(ItemFruit.EnumFruit.WALNUT.getStack());
        crateRegistry.registerCrate(ItemFruit.EnumFruit.CHESTNUT.getStack());
        crateRegistry.registerCrate(ItemFruit.EnumFruit.LEMON.getStack());
        crateRegistry.registerCrate(ItemFruit.EnumFruit.PLUM.getStack());
        crateRegistry.registerCrate(ItemFruit.EnumFruit.PAPAYA.getStack());
        crateRegistry.registerCrate(ItemFruit.EnumFruit.DATES.getStack());
    }

    @Override
    public void registerRecipes() {
        ItemRegistryCore coreItems = ModuleCore.getItems();
        BlockRegistryArboriculture blocks = ModuleArboriculture.getBlocks();
        ItemRegistryArboriculture items = ModuleArboriculture.getItems();
        for (BlockArbLog blockArbLog : blocks.logs) {
            ItemStack logInput = new ItemStack((Block)blockArbLog, 1, Short.MAX_VALUE);
            ItemStack coalOutput = new ItemStack(Items.field_151044_h, 1, 1);
            RecipeUtil.addSmelting(logInput, coalOutput, 0.15f);
        }
        ArrayList allWoodTypes = new ArrayList();
        Collections.addAll(allWoodTypes, EnumForestryWoodType.VALUES);
        Collections.addAll(allWoodTypes, EnumVanillaWoodType.VALUES);
        for (IWoodType woodType : allWoodTypes) {
            ItemStack planks = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.PLANKS, false);
            ItemStack logs = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.LOG, false);
            ItemStack slabs = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.SLAB, false);
            ItemStack fences = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.FENCE, false);
            ItemStack fenceGates = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.FENCE_GATE, false);
            ItemStack stairs = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.STAIRS, false);
            ItemStack doors = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.DOOR, false);
            ItemStack fireproofPlanks = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.PLANKS, true);
            ItemStack fireproofLogs = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.LOG, true);
            ItemStack fireproofSlabs = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.SLAB, true);
            ItemStack fireproofFences = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.FENCE, true);
            ItemStack fireproofFenceGates = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.FENCE_GATE, true);
            ItemStack fireproofStairs = TreeManager.woodAccess.getStack(woodType, WoodBlockKind.STAIRS, true);
            if (woodType instanceof EnumForestryWoodType) {
                planks.func_190920_e(4);
                logs.func_190920_e(1);
                RecipeUtil.addShapelessRecipe("planks_" + woodType.func_176610_l(), planks.func_77946_l(), logs.func_77946_l());
                slabs.func_190920_e(6);
                planks.func_190920_e(1);
                RecipeUtil.addRecipe("slabs_" + woodType.func_176610_l(), slabs.func_77946_l(), "###", Character.valueOf('#'), planks.func_77946_l());
                fences.func_190920_e(3);
                planks.func_190920_e(1);
                RecipeUtil.addRecipe("fences_" + woodType.func_176610_l(), fences.func_77946_l(), "#X#", "#X#", Character.valueOf('#'), planks.func_77946_l(), Character.valueOf('X'), "stickWood");
                fenceGates.func_190920_e(1);
                planks.func_190920_e(1);
                RecipeUtil.addRecipe("fence_gates_" + woodType.func_176610_l(), fenceGates.func_77946_l(), "X#X", "X#X", Character.valueOf('#'), planks.func_77946_l(), Character.valueOf('X'), "stickWood");
                stairs.func_190920_e(4);
                planks.func_190920_e(1);
                RecipeUtil.addRecipe("stairs_" + woodType.func_176610_l(), stairs.func_77946_l(), "#  ", "## ", "###", Character.valueOf('#'), planks.func_77946_l());
                doors.func_190920_e(3);
                planks.func_190920_e(1);
                RecipeUtil.addRecipe("doors_" + woodType.func_176610_l(), doors.func_77946_l(), "## ", "## ", "## ", Character.valueOf('#'), planks.func_77946_l());
            }
            fireproofPlanks.func_190920_e(4);
            fireproofLogs.func_190920_e(1);
            RecipeUtil.addShapelessRecipe("fireproof_planks_" + woodType.func_176610_l(), fireproofPlanks.func_77946_l(), fireproofLogs.func_77946_l());
            fireproofSlabs.func_190920_e(6);
            fireproofPlanks.func_190920_e(1);
            RecipeUtil.addRecipe("fireproof_slabs_" + woodType.func_176610_l(), fireproofSlabs.func_77946_l(), "###", Character.valueOf('#'), fireproofPlanks.func_77946_l());
            fireproofFences.func_190920_e(3);
            fireproofPlanks.func_190920_e(1);
            RecipeUtil.addRecipe("fireproof_fences_" + woodType.func_176610_l(), fireproofFences.func_77946_l(), "#X#", "#X#", Character.valueOf('#'), fireproofPlanks.func_77946_l(), Character.valueOf('X'), "stickWood");
            fireproofFenceGates.func_190920_e(1);
            fireproofPlanks.func_190920_e(1);
            RecipeUtil.addRecipe("fireproof_fence_gates_" + woodType.func_176610_l(), fireproofFenceGates.func_77946_l(), "X#X", "X#X", Character.valueOf('#'), fireproofPlanks.func_77946_l(), Character.valueOf('X'), "stickWood");
            fireproofStairs.func_190920_e(4);
            fireproofPlanks.func_190920_e(1);
            RecipeUtil.addRecipe("fireproof_stairs_" + woodType.func_176610_l(), fireproofStairs.func_77946_l(), "#  ", "## ", "###", Character.valueOf('#'), fireproofPlanks.func_77946_l());
            doors.func_190920_e(3);
            fireproofPlanks.func_190920_e(1);
            RecipeUtil.addRecipe("fireproof_doors_" + woodType.func_176610_l(), doors.func_77946_l(), "## ", "## ", "## ", Character.valueOf('#'), fireproofPlanks.func_77946_l());
            if (!ModuleHelper.isEnabled("factory", "apiculture")) continue;
            logs.func_190920_e(1);
            fireproofLogs.func_190920_e(1);
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, Fluids.GLASS.getFluid(500), fireproofLogs.func_77946_l(), new Object[]{" # ", "#X#", " # ", Character.valueOf('#'), coreItems.refractoryWax, Character.valueOf('X'), logs.func_77946_l()});
            planks.func_190920_e(1);
            fireproofPlanks.func_190920_e(5);
            RecipeManagers.fabricatorManager.addRecipe(ItemStack.field_190927_a, Fluids.GLASS.getFluid(500), fireproofPlanks.func_77946_l(), new Object[]{"X#X", "#X#", "X#X", Character.valueOf('#'), coreItems.refractoryWax, Character.valueOf('X'), planks.func_77946_l()});
        }
        if (ModuleHelper.isEnabled("factory")) {
            int n = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
            int juiceMultiplier = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple");
            int mulchMultiplier = ForestryAPI.activeMode.getIntegerSetting("squeezer.mulch.apple");
            ItemStack mulch = new ItemStack((Item)coreItems.mulch);
            RecipeManagers.squeezerManager.addRecipe(20, ItemFruit.EnumFruit.CHERRY.getStack(), Fluids.SEED_OIL.getFluid(5 * n), mulch, 5);
            RecipeManagers.squeezerManager.addRecipe(60, ItemFruit.EnumFruit.WALNUT.getStack(), Fluids.SEED_OIL.getFluid(18 * n), mulch, 5);
            RecipeManagers.squeezerManager.addRecipe(70, ItemFruit.EnumFruit.CHESTNUT.getStack(), Fluids.SEED_OIL.getFluid(22 * n), mulch, 2);
            RecipeManagers.squeezerManager.addRecipe(10, ItemFruit.EnumFruit.LEMON.getStack(), Fluids.JUICE.getFluid(juiceMultiplier * 2), mulch, (int)Math.floor((float)mulchMultiplier * 0.5f));
            RecipeManagers.squeezerManager.addRecipe(10, ItemFruit.EnumFruit.PLUM.getStack(), Fluids.JUICE.getFluid((int)Math.floor((float)juiceMultiplier * 0.5f)), mulch, mulchMultiplier * 3);
            RecipeManagers.squeezerManager.addRecipe(10, ItemFruit.EnumFruit.PAPAYA.getStack(), Fluids.JUICE.getFluid(juiceMultiplier * 3), mulch, (int)Math.floor((float)mulchMultiplier * 0.5f));
            RecipeManagers.squeezerManager.addRecipe(10, ItemFruit.EnumFruit.DATES.getStack(), Fluids.JUICE.getFluid((int)Math.floor((double)juiceMultiplier * 0.25)), mulch, mulchMultiplier);
            RecipeUtil.addFermenterRecipes(new ItemStack((Item)items.sapling, 1, Short.MAX_VALUE), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
        }
        RecipeUtil.addRecipe("grafter", items.grafter.getItemStack(), "  B", " # ", "#  ", Character.valueOf('B'), "ingotBronze", Character.valueOf('#'), "stickWood");
        RecipeUtil.addRecipe("tree_chest", blocks.treeChest, " # ", "XYX", "XXX", Character.valueOf('#'), "blockGlass", Character.valueOf('X'), "treeSapling", Character.valueOf('Y'), "chestWood");
    }

    private static void registerAlleles() {
        TreeBranchDefinition.registerAlleles();
        AlleleLeafEffects.registerAlleles();
    }

    private static void registerErsatzGenomes() {
        TreeManager.treeRoot.registerTranslator(Blocks.field_150362_t, new IBlockTranslator<ITree>(){

            @Override
            @Nullable
            public ITree getIndividualFromObject(IBlockState blockState) {
                if (!((Boolean)blockState.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue()) {
                    return null;
                }
                switch ((BlockPlanks.EnumType)blockState.func_177229_b((IProperty)BlockOldLeaf.field_176239_P)) {
                    case OAK: {
                        return TreeDefinition.Oak.getIndividual();
                    }
                    case SPRUCE: {
                        return TreeDefinition.Spruce.getIndividual();
                    }
                    case BIRCH: {
                        return TreeDefinition.Birch.getIndividual();
                    }
                    case JUNGLE: {
                        return TreeDefinition.Jungle.getIndividual();
                    }
                }
                return null;
            }
        });
        TreeManager.treeRoot.registerTranslator(Blocks.field_150361_u, new IBlockTranslator<ITree>(){

            @Override
            @Nullable
            public ITree getIndividualFromObject(IBlockState blockState) {
                if (!((Boolean)blockState.func_177229_b((IProperty)BlockLeaves.field_176237_a)).booleanValue()) {
                    return null;
                }
                switch ((BlockPlanks.EnumType)blockState.func_177229_b((IProperty)BlockNewLeaf.field_176240_P)) {
                    case ACACIA: {
                        return TreeDefinition.AcaciaVanilla.getIndividual();
                    }
                    case DARK_OAK: {
                        return TreeDefinition.DarkOak.getIndividual();
                    }
                }
                return null;
            }
        });
        TreeManager.treeRoot.registerTranslator(Item.func_150898_a((Block)Blocks.field_150345_g), new IItemTranslator<ITree>(){

            @Override
            @Nullable
            public ITree getIndividualFromObject(ItemStack itemStack) {
                switch (itemStack.func_77960_j()) {
                    case 0: {
                        return TreeDefinition.Oak.getIndividual();
                    }
                    case 1: {
                        return TreeDefinition.Spruce.getIndividual();
                    }
                    case 2: {
                        return TreeDefinition.Birch.getIndividual();
                    }
                    case 3: {
                        return TreeDefinition.Jungle.getIndividual();
                    }
                    case 4: {
                        return TreeDefinition.AcaciaVanilla.getIndividual();
                    }
                    case 5: {
                        return TreeDefinition.DarkOak.getIndividual();
                    }
                }
                return null;
            }
        });
        for (BlockDefaultLeaves leaves : ModuleArboriculture.getBlocks().leavesDefault) {
            TreeManager.treeRoot.registerTranslator(leaves, blockState -> {
                TreeDefinition treeDefinition = leaves.getTreeDefinition(blockState);
                if (treeDefinition != null) {
                    return treeDefinition.getIndividual();
                }
                return null;
            });
        }
    }

    @Override
    public IPacketRegistry getPacketRegistry() {
        return new PacketRegistryArboriculture();
    }

    @Override
    public boolean processIMCMessage(FMLInterModComms.IMCMessage message) {
        if (message.key.equals("add-fence-block") && message.isStringMessage()) {
            Block block = ItemStackUtil.getBlockFromRegistry(message.getStringValue());
            if (block != null) {
                validFences.add(block);
            } else {
                IMCUtil.logInvalidIMCMessage(message);
            }
            return true;
        }
        if (message.key.equals("blacklist-trees-dimension")) {
            int[] dims;
            for (int dim : dims = message.getNBTValue().func_74759_k("dimensions")) {
                Config.blacklistTreeDim(dim);
            }
            return true;
        }
        return false;
    }

    @Override
    public void getHiddenItems(List<ItemStack> hiddenItems) {
        hiddenItems.add(new ItemStack((Block)ModuleArboriculture.getBlocks().saplingGE));
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void registerSprites(TextureStitchEvent.Pre event) {
        TextureLeaves.registerAllSprites();
        WoodTextureManager.parseFile();
        for (IAlleleFruit alleleFruit : AlleleFruits.getFruitAlleles()) {
            alleleFruit.getProvider().registerSprites();
        }
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        for (IWoodType type : TreeManager.woodAccess.getRegisteredWoodTypes()) {
            textures.add(new ResourceLocation(type.getHeartTexture()));
            textures.add(new ResourceLocation(type.getBarkTexture()));
            textures.add(new ResourceLocation(type.getDoorLowerTexture()));
            textures.add(new ResourceLocation(type.getDoorUpperTexture()));
            textures.add(new ResourceLocation(type.getPlankTexture()));
            for (WoodBlockKind kind : WoodBlockKind.values()) {
                for (Map.Entry loc : WoodTextureManager.getTextures(type, kind).entrySet()) {
                    textures.add(new ResourceLocation((String)loc.getValue()));
                }
            }
        }
        for (ResourceLocation loc : textures) {
            TextureManagerForestry.registerSprite(loc);
        }
    }

    @SubscribeEvent
    @SideOnly(value=Side.CLIENT)
    public void onModelBake(ModelBakeEvent event) {
        ((ProxyArboricultureClient)proxy).onModelBake(event);
    }

    @Override
    public void populateChunkRetroGen(World world, Random rand, int chunkX, int chunkZ) {
        if (Config.generateTrees) {
            TreeDecorator.decorateTrees(world, rand, chunkX, chunkZ);
        }
    }

    @SubscribeEvent
    public void onHarvestDropsEvent(BlockEvent.HarvestDropsEvent event) {
        ItemStack harvestingTool;
        EntityPlayer player;
        IBlockState state = event.getState();
        Block block = state.func_177230_c();
        if (block instanceof BlockLeaves && !(block instanceof BlockForestryLeaves) && (player = event.getHarvester()) != null && (harvestingTool = player.func_184614_ca()).func_77973_b() instanceof ItemGrafter) {
            if (event.getDrops().isEmpty()) {
                World world = event.getWorld();
                Item itemDropped = block.func_180660_a(state, world.field_73012_v, 3);
                if (itemDropped != Items.field_190931_a) {
                    event.getDrops().add(new ItemStack(itemDropped, 1, block.func_180651_a(state)));
                }
            }
            harvestingTool.func_77972_a(1, (EntityLivingBase)player);
            if (harvestingTool.func_190926_b()) {
                ForgeEventFactory.onPlayerDestroyItem((EntityPlayer)player, (ItemStack)harvestingTool, (EnumHand)EnumHand.MAIN_HAND);
            }
        }
    }

    static {
        treekeepingMode = "NORMAL";
        validFences = new ArrayList<Block>();
    }
}

