/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture.commands;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.ISpeciesType;
import forestry.core.commands.CommandHelpers;
import forestry.core.commands.SpeciesNotFoundException;
import forestry.core.commands.SubCommand;
import forestry.core.commands.TemplateNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;

public class CommandBeeGive
extends SubCommand {
    private final String beeTypeHelpString;
    private final String[] beeTypeArr;

    public CommandBeeGive() {
        super("give");
        this.setPermLevel(SubCommand.PermLevel.ADMIN);
        ArrayList<String> beeTypeStrings = new ArrayList<String>();
        for (EnumBeeType type : EnumBeeType.values()) {
            beeTypeStrings.add(type.getName());
        }
        this.beeTypeArr = beeTypeStrings.toArray(new String[beeTypeStrings.size()]);
        StringBuilder beeTypeHelp = new StringBuilder();
        String separator = ", ";
        Iterator iter = beeTypeStrings.iterator();
        while (iter.hasNext()) {
            beeTypeHelp.append((String)iter.next());
            if (!iter.hasNext()) continue;
            beeTypeHelp.append(separator);
        }
        this.beeTypeHelpString = beeTypeHelp.toString();
    }

    @Override
    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length < 2) {
            this.printHelp(sender);
            return;
        }
        IBeeGenome beeGenome = CommandBeeGive.getBeeGenome(args[0]);
        EnumBeeType beeType = CommandBeeGive.getBeeType(args[1]);
        if (beeType == null) {
            this.printHelp(sender);
            return;
        }
        EntityPlayerMP player = args.length == 3 ? CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)args[2]) : CommandBase.func_184888_a((MinecraftServer)server, (ICommandSender)sender, (String)sender.func_70005_c_());
        IBee bee = BeeManager.beeRoot.getBee(beeGenome);
        if (beeType == EnumBeeType.QUEEN) {
            bee.mate(bee);
        }
        ItemStack beeStack = BeeManager.beeRoot.getMemberStack(bee, (ISpeciesType)beeType);
        player.func_146097_a(beeStack, false, true);
        CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.bee.give.given", player.func_70005_c_(), bee.getGenome().getPrimary().getAlleleName(), beeType.getName());
    }

    private static IBeeGenome getBeeGenome(String speciesName) throws SpeciesNotFoundException, TemplateNotFoundException {
        IAlleleBeeSpecies species = null;
        for (String uid : AlleleManager.alleleRegistry.getRegisteredAlleles().keySet()) {
            IAllele allele;
            if (!uid.equals(speciesName) || !((allele = AlleleManager.alleleRegistry.getAllele(uid)) instanceof IAlleleBeeSpecies)) continue;
            species = (IAlleleBeeSpecies)allele;
            break;
        }
        if (species == null) {
            for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                if (!(allele instanceof IAlleleBeeSpecies) || !allele.getAlleleName().equals(speciesName)) continue;
                species = (IAlleleBeeSpecies)allele;
                break;
            }
        }
        if (species == null) {
            throw new SpeciesNotFoundException(speciesName);
        }
        IAllele[] template = BeeManager.beeRoot.getTemplate(species);
        return BeeManager.beeRoot.templateAsGenome(template);
    }

    @Override
    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length == 1) {
            List<String> tabCompletion = CommandHelpers.getListOfStringsMatchingLastWord(args, CommandBeeGive.getSpecies());
            tabCompletion.add("help");
            return tabCompletion;
        }
        if (args.length == 2) {
            return CommandHelpers.getListOfStringsMatchingLastWord(args, this.beeTypeArr);
        }
        if (args.length == 3) {
            return CommandHelpers.getListOfStringsMatchingLastWord(args, server.func_71213_z());
        }
        return Collections.emptyList();
    }

    private static String[] getSpecies() {
        ArrayList<String> species = new ArrayList<String>();
        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
            if (!(allele instanceof IAlleleBeeSpecies)) continue;
            species.add(allele.getAlleleName());
        }
        return species.toArray(new String[species.size()]);
    }

    @Nullable
    private static EnumBeeType getBeeType(String beeTypeName) {
        for (EnumBeeType beeType : EnumBeeType.values()) {
            if (!beeType.getName().equalsIgnoreCase(beeTypeName)) continue;
            return beeType;
        }
        return null;
    }

    @Override
    public void printHelp(ICommandSender sender) {
        super.printHelp(sender);
        CommandHelpers.sendLocalizedChatMessage(sender, "for.chat.command.forestry.beekeeping.give.available", this.beeTypeHelpString);
    }
}

