package forestry.book.gui.buttons;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;

import forestry.api.book.IBookCategory;
import forestry.core.gui.GuiUtil;
import forestry.core.gui.tooltips.IToolTipProvider;
import forestry.core.gui.tooltips.ToolTip;

public class GuiButtonBookCategory extends GuiButton implements IToolTipProvider {
	public final IBookCategory category;

	public GuiButtonBookCategory(int buttonId, int x, int y, IBookCategory category) {
		super(buttonId, x, y, 32, 32, "");
		this.category = category;
	}

	@Override
	public void func_191745_a(Minecraft mc, int mouseX, int mouseY, float partialTicks) {
		if (field_146125_m) {
			this.field_146123_n = mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
			FontRenderer fontRenderer = mc.field_71466_p;
			GlStateManager.func_179094_E();
			GlStateManager.func_179109_b(field_146128_h, field_146129_i, field_73735_i);
			GlStateManager.func_179152_a(2F, 2F, 2F);
			GlStateManager.func_179131_c(1.0F, 1.0F, 1.0F, 1.0F);
			RenderHelper.func_74520_c();
			GlStateManager.func_179091_B();
			GuiUtil.drawItemStack(fontRenderer, category.getStack(), 0, 0);
			RenderHelper.func_74518_a();
			GlStateManager.func_179121_F();
		}
	}

	@Override
	public ToolTip getToolTip(int mouseX, int mouseY) {
		ToolTip toolTip = new ToolTip();
		toolTip.add(category.getLocalizedName());
		return toolTip;
	}

	@Override
	public boolean isToolTipVisible() {
		return true;
	}

	@Override
	public boolean isMouseOver(int mouseX, int mouseY) {
		return mouseX >= this.field_146128_h && mouseY >= this.field_146129_i && mouseX < this.field_146128_h + this.field_146120_f && mouseY < this.field_146129_i + this.field_146121_g;
	}

	@Override
	public boolean isRelativeToGui() {
		return false;
	}
}
