/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.worldgen;

import java.util.HashSet;
import java.util.Set;

import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class HiveGenGround extends HiveGen {

	private final Set<Material> groundMaterials = new HashSet<>();

	public HiveGenGround(Block... groundBlocks) {
		for (Block block : groundBlocks) {
			IBlockState blockState = block.func_176223_P();
			Material blockMaterial = blockState.func_185904_a();
			groundMaterials.add(blockMaterial);
		}
	}

	@Override
	public boolean isValidLocation(World world, BlockPos pos) {
		IBlockState groundBlockState = world.func_180495_p(pos.func_177977_b());
		Material groundBlockMaterial = groundBlockState.func_185904_a();
		return groundMaterials.contains(groundBlockMaterial);
	}

	@Override
	public BlockPos getPosForHive(World world, int x, int z) {
		// get to the ground
		final BlockPos topPos = world.func_175645_m(new BlockPos(x, 0, z));
		if (topPos.func_177956_o() == 0) {
			return null;
		}

		final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(topPos);

		IBlockState blockState = world.func_180495_p(pos);
		while (isTreeBlock(blockState, world, pos) || canReplace(blockState, world, pos)) {
			pos.func_189536_c(EnumFacing.DOWN);
			if (pos.func_177956_o() <= 0) {
				return null;
			}
			blockState = world.func_180495_p(pos);
		}

		return pos.func_177984_a();
	}
}
