/*
 * Decompiled with CFR 0.152.
 */
package forestry.database;

import forestry.api.apiculture.IBee;
import forestry.api.arboriculture.ITree;
import forestry.api.core.GuiElementAlignment;
import forestry.api.core.IGuiElementHelper;
import forestry.api.core.IGuiElementLayoutHelper;
import forestry.api.genetics.EnumDatabaseTab;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IDatabaseTab;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.gui.elements.GuiElementItemStack;
import forestry.core.utils.Translator;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;

public enum DatabaseTab implements IDatabaseTab
{
    PRODUCTS{

        public void createElements(IGuiElementHelper layoutHelper, IIndividual individual, ItemStack itemStack) {
            Collection<ItemStack> specialties;
            IGuiElementLayoutHelper groupHelper = layoutHelper.layoutHelper((x, y) -> layoutHelper.factory().createHorizontal(x + 4, y, 18).setDistance(2), 90, 0);
            Collection<ItemStack> products = this.getProducts(individual);
            if (!products.isEmpty()) {
                layoutHelper.addText(Translator.translateToLocal("for.gui.beealyzer.produce"), GuiElementAlignment.CENTER);
                products.forEach(product -> groupHelper.add(new GuiElementItemStack(0, 0, (ItemStack)product)));
                groupHelper.finish();
            }
            if ((specialties = this.getSpecialties(individual)).isEmpty()) {
                return;
            }
            layoutHelper.addText(Translator.translateToLocal("for.gui.beealyzer.specialty"), GuiElementAlignment.CENTER);
            specialties.forEach(specialty -> groupHelper.add(new GuiElementItemStack(0, 0, (ItemStack)specialty)));
            groupHelper.finish();
        }

        public Collection<ItemStack> getSpecialties(IIndividual individual) {
            if (individual instanceof IBee) {
                IBee bee = (IBee)individual;
                return bee.getSpecialtyList();
            }
            if (individual instanceof ITree) {
                ITree tree = (ITree)individual;
                return tree.getSpecialties().keySet();
            }
            return Collections.emptyList();
        }

        public Collection<ItemStack> getProducts(IIndividual individual) {
            if (individual instanceof IBee) {
                IBee bee = (IBee)individual;
                return bee.getProduceList();
            }
            if (individual instanceof ITree) {
                ITree tree = (ITree)individual;
                return tree.getProducts().keySet();
            }
            return Collections.emptyList();
        }

        @Override
        public EnumDatabaseTab getTab() {
            return EnumDatabaseTab.PRODUCTS;
        }
    }
    ,
    MUTATIONS{

        public void createElements(IGuiElementHelper layoutHelper, IIndividual individual, ItemStack itemStack) {
            IGenome genome = individual.getGenome();
            ISpeciesRoot speciesRoot = genome.getSpeciesRoot();
            IAlleleSpecies species = genome.getPrimary();
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            IBreedingTracker breedingTracker = speciesRoot.getBreedingTracker(player.field_70170_p, player.func_146103_bH());
            IGuiElementLayoutHelper groupHelper = layoutHelper.layoutHelper((x, y) -> layoutHelper.factory().createHorizontal(x + 1, y, 16), 100, 0);
            Collection<? extends IMutation> mutations = this.getValidMutations(speciesRoot.getCombinations(species));
            if (!mutations.isEmpty()) {
                layoutHelper.addText(TextFormatting.UNDERLINE + Translator.translateToLocal("for.gui.database.mutations.further"), GuiElementAlignment.CENTER);
                mutations.forEach(mutation -> groupHelper.add(layoutHelper.factory().createMutation(0, 0, 50, 16, (IMutation)mutation, species, breedingTracker)));
                groupHelper.finish();
            }
            if ((mutations = this.getValidMutations(speciesRoot.getResultantMutations(species))).isEmpty()) {
                return;
            }
            layoutHelper.addText(TextFormatting.UNDERLINE + Translator.translateToLocal("for.gui.database.mutations.resultant"), GuiElementAlignment.CENTER);
            mutations.forEach(mutation -> groupHelper.add(layoutHelper.factory().createMutationResultant(0, 0, 50, 16, (IMutation)mutation, breedingTracker)));
            groupHelper.finish();
        }

        public Collection<? extends IMutation> getValidMutations(List<? extends IMutation> mutations) {
            Iterator<? extends IMutation> iterator = mutations.iterator();
            while (iterator.hasNext()) {
                IMutation mutation = iterator.next();
                if (!mutation.isSecret()) continue;
                iterator.remove();
            }
            return mutations;
        }

        @Override
        public EnumDatabaseTab getTab() {
            return EnumDatabaseTab.MUTATIONS;
        }
    };


    public String getTooltip(IIndividual individual) {
        return I18n.func_74838_a((String)("for.gui.database.tab." + this.getTab().toString().toLowerCase() + ".name"));
    }
}

