/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.circuits;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.CircuitSocketType;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitBoard;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.circuits.ICircuitSocketType;
import forestry.core.circuits.EnumCircuitBoardType;
import forestry.core.utils.Translator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class CircuitBoard
implements ICircuitBoard {
    private final EnumCircuitBoardType type;
    @Nullable
    private final ICircuitLayout layout;
    private final ICircuit[] circuits;

    public CircuitBoard(EnumCircuitBoardType type, @Nullable ICircuitLayout layout, ICircuit[] circuits) {
        this.type = type;
        this.layout = layout;
        this.circuits = circuits;
    }

    public CircuitBoard(NBTTagCompound nbttagcompound) {
        this.type = EnumCircuitBoardType.values()[nbttagcompound.func_74765_d("T")];
        ICircuitLayout layout = null;
        if (nbttagcompound.func_74764_b("LY")) {
            layout = ChipsetManager.circuitRegistry.getLayout(nbttagcompound.func_74779_i("LY"));
        }
        if (layout == null) {
            ChipsetManager.circuitRegistry.getDefaultLayout();
        }
        this.layout = layout;
        this.circuits = new ICircuit[4];
        for (int i = 0; i < 4; ++i) {
            ICircuit circuit;
            if (!nbttagcompound.func_74764_b("CA.I" + i) || (circuit = ChipsetManager.circuitRegistry.getCircuit(nbttagcompound.func_74779_i("CA.I" + i))) == null) continue;
            this.circuits[i] = circuit;
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getPrimaryColor() {
        return this.type.getPrimaryColor();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public int getSecondaryColor() {
        return this.type.getSecondaryColor();
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addTooltip(List<String> list) {
        if (this.layout != null) {
            list.add(TextFormatting.GOLD + this.layout.getUsage() + ":");
            ArrayList<String> extendedTooltip = new ArrayList<String>();
            for (ICircuit circuit : this.circuits) {
                if (circuit == null) continue;
                circuit.addTooltip(extendedTooltip);
            }
            if (GuiScreen.func_146272_n() || extendedTooltip.size() <= 4) {
                list.addAll(extendedTooltip);
            } else {
                list.add(TextFormatting.ITALIC + "<" + Translator.translateToLocal("for.gui.tooltip.tmi") + ">");
            }
        } else {
            int socketCount = this.type.getSockets();
            String localizationKey = "item.for.circuitboard.tooltip." + (socketCount == 1 ? "singular" : "plural");
            String tooltip = Translator.translateToLocalFormatted(localizationKey, this.type.getSockets());
            list.add(tooltip);
        }
    }

    @Override
    public NBTTagCompound writeToNBT(NBTTagCompound nbttagcompound) {
        nbttagcompound.func_74777_a("T", (short)this.type.ordinal());
        if (this.layout != null) {
            nbttagcompound.func_74778_a("LY", this.layout.getUID());
        }
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            nbttagcompound.func_74778_a("CA.I" + i, circuit.getUID());
        }
        return nbttagcompound;
    }

    @Override
    public void onInsertion(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onInsertion(i, tile);
        }
    }

    @Override
    public void onLoad(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onLoad(i, tile);
        }
    }

    @Override
    public void onRemoval(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onRemoval(i, tile);
        }
    }

    @Override
    public void onTick(Object tile) {
        for (int i = 0; i < this.circuits.length; ++i) {
            ICircuit circuit = this.circuits[i];
            if (circuit == null) continue;
            circuit.onTick(i, tile);
        }
    }

    @Override
    public ICircuit[] getCircuits() {
        return this.circuits;
    }

    @Override
    public ICircuitSocketType getSocketType() {
        if (this.layout == null) {
            return CircuitSocketType.NONE;
        }
        return this.layout.getSocketType();
    }
}

