/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.Iterables;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.IFarmProperties;
import forestry.api.fuels.FuelManager;
import forestry.api.fuels.MoistenerFuel;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.ICrateRegistry;
import forestry.api.storage.StorageManager;
import forestry.core.ModuleCore;
import forestry.core.fluids.Fluids;
import forestry.core.items.ItemRegistryCore;
import forestry.core.recipes.RecipeUtil;
import forestry.core.utils.ItemStackUtil;
import forestry.core.utils.Log;
import forestry.core.utils.ModUtil;
import forestry.farming.FarmRegistry;
import forestry.farming.logic.farmables.FarmableAgingCrop;
import forestry.farming.logic.farmables.FarmableSapling;
import forestry.farming.logic.farmables.FarmableVanillaMushroom;
import forestry.modules.BlankForestryModule;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.GameRegistry;

@ForestryModule(containerID="forestry_compat", moduleID="natura", name="Natura", author="SirSengir", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.natura.description")
public class PluginNatura
extends BlankForestryModule {
    public static final String MOD_ID = "natura";
    @GameRegistry.ObjectHolder(value="natura:nether_green_large_glowshroom")
    private static final Block greenLargeGlowshroomBlock = null;
    @GameRegistry.ObjectHolder(value="natura:nether_blue_large_glowshroom")
    private static final Block blueLargeGlowshroomBlock = null;
    @GameRegistry.ObjectHolder(value="natura:nether_purple_large_glowshroom")
    private static final Block purpleLargeGlowshroomBlock = null;
    private static final ArrayList<ItemStack> fruits = new ArrayList();
    private static final ArrayList<ItemStack> soups = new ArrayList();
    private static final ArrayList<ItemStack> berries = new ArrayList();
    private static final ArrayList<ItemStack> edibles = new ArrayList();
    private static final ArrayList<ItemStack> seeds = new ArrayList();
    private static final ArrayList<ItemStack> logs = new ArrayList();
    private static final ArrayList<ItemStack> saplings = new ArrayList();
    private static final ArrayList<ItemStack> shrooms = new ArrayList();
    private static final ArrayList<ItemStack> materials = new ArrayList();
    private static final ArrayList<ItemStack> crops = new ArrayList();
    private static final ArrayList<ItemStack> cropBlocks = new ArrayList();

    public PluginNatura() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(MOD_ID);
    }

    @Override
    public String getFailMessage() {
        return "Natura not found";
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent<Item> itemRegistryEvent) {
        ItemStack potashApple = this.findPotashAppleInRegistry();
        boolean hasMushroom = blueLargeGlowshroomBlock != null && greenLargeGlowshroomBlock != null && purpleLargeGlowshroomBlock != null;
        ForgeRegistries.ITEMS.forEach(item -> {
            ResourceLocation registryName = item.getRegistryName();
            if (registryName == null || !registryName.func_110624_b().equals(MOD_ID)) {
                return;
            }
            String itemName = registryName.func_110623_a();
            if (itemName.matches("^.*_sapling\\d?$")) {
                this.consumeSubItems((Item)item, "saplings", (Collection<ItemStack>)saplings);
                RecipeUtil.addFermenterRecipes(new ItemStack(item, 1, Short.MAX_VALUE), ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.sapling"), Fluids.BIOMASS);
                ItemStack[] windfall = new ItemStack[]{};
                if (itemName.endsWith("nether_sapling")) {
                    windfall = new ItemStack[]{potashApple};
                }
                FarmRegistry.getInstance().registerFarmables("farmArboreal", new FarmableSapling(new ItemStack(item), windfall));
                return;
            }
            if (hasMushroom && itemName.matches("^.*nether_glowshroom\\d?$")) {
                this.complexConsumeSubItems((Item)item, "shrooms", subItem -> {
                    shrooms.add((ItemStack)subItem);
                    Block largeShroomBlock = subItem.func_77960_j() == blueLargeGlowshroomBlock.func_180651_a(blueLargeGlowshroomBlock.func_176223_P()) ? blueLargeGlowshroomBlock : (subItem.func_77960_j() == greenLargeGlowshroomBlock.func_180651_a(greenLargeGlowshroomBlock.func_176223_P()) ? greenLargeGlowshroomBlock : purpleLargeGlowshroomBlock);
                    Block smallShroomBlock = Block.func_149634_a((Item)subItem.func_77973_b());
                    FarmRegistry.getInstance().registerFarmables("farmShroom", new FarmableVanillaMushroom((ItemStack)subItem, smallShroomBlock.func_176203_a(subItem.func_77960_j()), largeShroomBlock));
                });
                return;
            }
            if (itemName.matches("^edibles|.*fruit_item|soups$")) {
                this.complexConsumeSubItems((Item)item, "edibles", subitem -> {
                    String subItemName = subitem.func_77977_a();
                    if (subItemName.matches("^.*berry$")) {
                        berries.add((ItemStack)subitem);
                        return;
                    }
                    if (subItemName.matches("^.*(fruit_item|apple)$")) {
                        fruits.add((ItemStack)subitem);
                        return;
                    }
                    if (subItemName.matches("^.*stew$")) {
                        soups.add((ItemStack)subitem);
                        return;
                    }
                    edibles.add((ItemStack)subitem);
                });
            }
            if (itemName.matches("^.*_seeds$")) {
                this.consumeSubItems((Item)item, "seeds", (Collection<ItemStack>)seeds);
                return;
            }
            if (itemName.matches("^.*_logs\\d?$")) {
                this.consumeSubItems((Item)item, "logs", (Collection<ItemStack>)logs);
                return;
            }
            if (itemName.matches("^.*_crop\\d?$")) {
                this.consumeSubItems((Item)item, "cropBlocks", (Collection<ItemStack>)cropBlocks);
                return;
            }
            if (itemName.matches("^materials$")) {
                this.complexConsumeSubItems((Item)item, "materials", subitem -> {
                    String subItemName = subitem.func_77977_a();
                    if (subItemName.matches("^.*(barley|cotton)$")) {
                        crops.add((ItemStack)subitem);
                        return;
                    }
                    materials.add((ItemStack)subitem);
                });
            }
        });
    }

    private void consumeSubItems(Item item, String groupName, Collection<ItemStack> consumer) {
        this.complexConsumeSubItems(item, groupName, consumer::add);
    }

    private void complexConsumeSubItems(Item item, String groupName, Consumer<ItemStack> consumer) {
        NonNullList subItems = NonNullList.func_191196_a();
        item.func_150895_a(CreativeTabs.field_78027_g, subItems);
        if (subItems.isEmpty()) {
            ItemStack itemStack2 = new ItemStack(item, 1);
            String subItemName = itemStack2.func_77977_a();
            Log.info("[PluginNatura] Adding '{}' to list of {}", subItemName, groupName);
            consumer.accept(itemStack2);
            return;
        }
        subItems.forEach(itemStack -> {
            String subItemName = itemStack.func_77977_a();
            Log.info("[PluginNatura] Adding '{}' to list of {}", subItemName, groupName);
            consumer.accept((ItemStack)itemStack);
        });
    }

    private ItemStack findPotashAppleInRegistry() {
        Item edibleItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(MOD_ID, "edibles"));
        if (edibleItem != null) {
            NonNullList edibleSubItems = NonNullList.func_191196_a();
            edibleItem.func_150895_a(CreativeTabs.field_78027_g, edibleSubItems);
            for (ItemStack edibleSubItem : edibleSubItems) {
                if (!edibleSubItem.func_77977_a().endsWith("potashapple")) continue;
                return edibleSubItem;
            }
        }
        return ItemStack.field_190927_a;
    }

    @Override
    public void registerCrates() {
        ICrateRegistry crateRegistry = StorageManager.crateRegistry;
        Iterables.concat((Iterable[])new Iterable[]{edibles, logs, saplings, shrooms, materials, seeds, berries, fruits, crops}).forEach(crateRegistry::registerCrate);
    }

    @Override
    public void registerRecipes() {
        int amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        for (ItemStack seed : seeds) {
            RecipeManagers.squeezerManager.addRecipe(10, (NonNullList<ItemStack>)NonNullList.func_193580_a((Object)seed, (Object[])new ItemStack[]{seed}), Fluids.SEED_OIL.getFluid(amount));
            RecipeManagers.moistenerManager.addRecipe(seed, new ItemStack((Block)Blocks.field_150391_bh), 5000);
        }
        if (ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "farming"))) {
            cropBlocks.forEach(itemStack -> {
                ItemStack seedItem;
                int maxAge;
                Block block = ItemStackUtil.getBlock(itemStack);
                try {
                    maxAge = (Integer)block.getClass().getDeclaredMethod("getMaxAge", new Class[0]).invoke((Object)block, new Object[0]);
                    seedItem = block.getPickBlock(block.func_176194_O().func_177621_b(), null, null, null, null);
                }
                catch (Exception ignored) {
                    return;
                }
                Log.info("[PluginNatura] Addding crop '{}'", itemStack);
                if (seedItem.func_190926_b()) {
                    return;
                }
                FarmRegistry.getInstance().registerFarmables("farmCrops", new FarmableAgingCrop(seedItem, block, (IProperty<Integer>)block.func_176194_O().func_185920_a("age"), maxAge));
            });
        }
        ItemRegistryCore coreItems = ModuleCore.getItems();
        amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple") / 2;
        int juiceAmount = Math.max(amount, 1);
        ItemStack mulch = coreItems.mulch.getItemStack();
        fruits.forEach(fruit -> RecipeManagers.squeezerManager.addRecipe(10, (NonNullList<ItemStack>)NonNullList.func_193580_a((Object)fruit, (Object[])new ItemStack[]{fruit}), Fluids.JUICE.getFluid(juiceAmount), mulch, ForestryAPI.activeMode.getIntegerSetting("squeezer.mulch.apple")));
        amount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple") / 25;
        amount = Math.max(amount, 1);
        for (ItemStack berry : berries) {
            RecipeManagers.squeezerManager.addRecipe(3, (NonNullList<ItemStack>)NonNullList.func_193580_a((Object)berry, (Object[])new ItemStack[]{berry}), Fluids.JUICE.getFluid(amount));
        }
        crops.forEach(crop -> {
            RecipeUtil.addFermenterRecipes(crop, ForestryAPI.activeMode.getIntegerSetting("fermenter.yield.wheat"), Fluids.BIOMASS);
            if (crop.func_77977_a().matches("^.*cotton$")) {
                return;
            }
            int compostWheatAmount = ForestryAPI.activeMode.getIntegerSetting("recipe.output.compost.wheat");
            if (compostWheatAmount > 0) {
                ItemStack compostWheat = coreItems.fertilizerCompound.getItemStack(compostWheatAmount);
                RecipeUtil.addRecipe(compostWheat.func_77977_a(), compostWheat, " X ", "X#X", " X ", Character.valueOf('#'), Blocks.field_150346_d, Character.valueOf('X'), crop);
            }
            FuelManager.moistenerResource.put((ItemStack)crop, new MoistenerFuel((ItemStack)crop, coreItems.mouldyWheat.getItemStack(), 0, 300));
        });
    }

    @Override
    public void postInit() {
        FarmRegistry registry = FarmRegistry.getInstance();
        IFarmProperties mushroomFarm = registry.getProperties("farmShroom");
        IFarmProperties farmArboreal = registry.getProperties("farmArboreal");
        if (farmArboreal != null) {
            farmArboreal.registerSoil(new ItemStack(Blocks.field_150424_aL), Blocks.field_150424_aL.func_176223_P());
        }
        if (mushroomFarm != null) {
            mushroomFarm.registerSoil(new ItemStack(Blocks.field_150424_aL), Blocks.field_150424_aL.func_176223_P());
            mushroomFarm.registerSoil(new ItemStack(Blocks.field_150425_aM), Blocks.field_150425_aM.func_176223_P());
        }
    }
}

