/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.apiculture.entities;

import javax.annotation.Nullable;

import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.RandomPositionGenerator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathNavigate;
import net.minecraft.util.math.Vec3d;

public class AIAvoidPlayers extends EntityAIBase {

	private final EntityCreature mob;
	private final PathNavigate pathNavigator;

	private final float farSpeed;
	private final float nearSpeed;
	private final float minDistance;

	@Nullable
	private Path path;

	@Nullable
	private EntityPlayer player;

	public AIAvoidPlayers(EntityCreature mob, float minDistance, float farSpeed, float nearSpeed) {
		this.mob = mob;
		this.minDistance = minDistance;
		this.farSpeed = farSpeed;
		this.nearSpeed = nearSpeed;
		this.pathNavigator = mob.func_70661_as();
		this.func_75248_a(1);
	}

	@Override
	public boolean func_75250_a() {

		player = mob.field_70170_p.func_72890_a(mob, minDistance);

		if (player == null) {
			return false;
		}

		if (!mob.func_70635_at().func_75522_a(player)) {
			return false;
		}

		Vec3d randomTarget = RandomPositionGenerator.func_75461_b(mob, 16, 7,
				new Vec3d(player.field_70165_t, player.field_70163_u, player.field_70161_v));

		if (randomTarget == null) {
			return false;
		}
		
		if (player.func_70092_e(randomTarget.field_72450_a, randomTarget.field_72448_b, randomTarget.field_72449_c) < player.func_70068_e(mob)) {
			return false;
		}
		
		path = pathNavigator.func_75488_a(randomTarget.field_72450_a, randomTarget.field_72448_b, randomTarget.field_72449_c);
		return path != null;
	}

	@Override
	public boolean func_75253_b() {
		return !this.pathNavigator.func_75500_f();
	}

	@Override
	public void func_75249_e() {
		this.pathNavigator.func_75484_a(path, farSpeed);
	}

	@Override
	public void func_75251_c() {
		player = null;
	}

	@Override
	public void func_75246_d() {
		if (player != null && mob.func_70068_e(player) < 49.0D) {
			mob.func_70661_as().func_75489_a(nearSpeed);
		} else {
			mob.func_70661_as().func_75489_a(farSpeed);
		}
	}
}
