/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic.farmables;

import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.core.network.packets.PacketFXSignal;
import forestry.core.utils.NetworkUtil;
import forestry.farming.logic.crops.CropDestroy;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class FarmableRusticSapling
implements IFarmable {
    protected final Item germling;
    protected final Block germlingBlock;
    private final ItemStack[] windfall;

    public FarmableRusticSapling(Item germling, ItemStack[] windfall) {
        this.germling = germling;
        this.germlingBlock = Block.func_149634_a((Item)germling);
        this.windfall = windfall;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        if (world.func_175656_a(pos, this.germlingBlock.func_176203_a(germling.func_77952_i()))) {
            PacketFXSignal packet = new PacketFXSignal(PacketFXSignal.SoundFXType.BLOCK_PLACE, pos, this.germlingBlock.func_176203_a(germling.func_77952_i()));
            NetworkUtil.sendNetworkPacket(packet, pos, world);
            return true;
        }
        return false;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos, IBlockState blockState) {
        return blockState.func_177230_c() == this.germlingBlock;
    }

    @Override
    public ICrop getCropAt(World world, BlockPos pos, IBlockState blockState) {
        Block block = blockState.func_177230_c();
        if (!block.isWood((IBlockAccess)world, pos)) {
            return null;
        }
        return new CropDestroy(world, blockState, pos, null);
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return this.germling == itemstack.func_77973_b();
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        for (ItemStack drop : this.windfall) {
            if (!drop.func_77969_a(itemstack)) continue;
            return true;
        }
        return false;
    }
}

