/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.items;

import forestry.api.core.IModelManager;
import forestry.core.CreativeTabForestry;
import forestry.core.config.Config;
import forestry.core.fluids.Fluids;
import forestry.core.items.DrinkProperties;
import forestry.core.items.EnumContainerType;
import forestry.core.items.FluidHandlerItemForestry;
import forestry.core.items.ItemForestry;
import forestry.core.utils.Translator;
import java.util.Iterator;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.FoodStats;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemFluidContainerForestry
extends ItemForestry {
    private final EnumContainerType type;

    public ItemFluidContainerForestry(EnumContainerType type) {
        super(CreativeTabForestry.tabForestry);
        this.type = type;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerModel(Item item, IModelManager manager) {
        String identifier = "liquids/" + this.type.toString().toLowerCase(Locale.ENGLISH);
        manager.registerItemModel(item, 0, identifier + "_empty");
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)1, (ModelResourceLocation)new ModelResourceLocation(new ResourceLocation("forestry", identifier), "inventory"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this));
            Iterator iterator = FluidRegistry.getRegisteredFluids().values().iterator();
            while (iterator.hasNext()) {
                ItemStack itemStack = new ItemStack((Item)this);
                FluidHandlerItemForestry fluidHandler = new FluidHandlerItemForestry(itemStack, this.type);
                Fluid fluid = (Fluid)iterator.next();
                if (fluidHandler.fill(new FluidStack(fluid, 1000), true) != 1000) continue;
                ItemStack filled = fluidHandler.getContainer();
                subItems.add((Object)filled);
            }
        }
    }

    public EnumContainerType getType() {
        return this.type;
    }

    @Nullable
    protected FluidStack getContained(ItemStack itemStack) {
        if (itemStack.func_190916_E() != 1) {
            itemStack = itemStack.func_77946_l();
            itemStack.func_190920_e(1);
        }
        FluidHandlerItemForestry fluidHandler = new FluidHandlerItemForestry(itemStack, this.type);
        return fluidHandler.drain(Integer.MAX_VALUE, false);
    }

    public String func_77653_i(ItemStack stack) {
        Item item = stack.func_77973_b();
        if (item instanceof ItemFluidContainerForestry) {
            FluidStack fluid = this.getContained(stack);
            if (fluid != null) {
                String exactTranslationKey = "item.for." + this.type.getName() + '.' + fluid.getFluid().getName() + ".name";
                if (Translator.canTranslateToLocal(exactTranslationKey)) {
                    return Translator.translateToLocal(exactTranslationKey);
                }
                String grammarKey = "item.for." + this.type.getName() + ".grammar";
                return Translator.translateToLocalFormatted(grammarKey, fluid.getLocalizedName());
            }
            String unlocalizedname = "item.for." + this.type.getName() + ".empty.name";
            return Translator.translateToLocal(unlocalizedname);
        }
        return super.func_77653_i(stack);
    }

    public ItemStack func_77654_b(ItemStack stack, World worldIn, EntityLivingBase entityLiving) {
        DrinkProperties drinkProperties = this.getDrinkProperties(stack);
        if (drinkProperties != null && entityLiving instanceof EntityPlayer && !((EntityPlayer)entityLiving).field_71075_bZ.field_75098_d) {
            EntityPlayer player = (EntityPlayer)entityLiving;
            if (!player.field_71075_bZ.field_75098_d) {
                stack.func_190918_g(1);
            }
            if (!worldIn.field_72995_K) {
                FoodStats foodStats = player.func_71024_bL();
                foodStats.func_75122_a(drinkProperties.getHealAmount(), drinkProperties.getSaturationModifier());
                worldIn.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187739_dZ, SoundCategory.PLAYERS, 0.5f, worldIn.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            player.func_71029_a(StatList.func_188057_b((Item)this));
        }
        return stack;
    }

    @Nullable
    protected DrinkProperties getDrinkProperties(ItemStack itemStack) {
        Fluids definition;
        FluidStack contained = this.getContained(itemStack);
        if (contained != null && (definition = Fluids.getFluidDefinition(contained)) != null) {
            return definition.getDrinkProperties();
        }
        return null;
    }

    public int func_77626_a(ItemStack itemstack) {
        DrinkProperties drinkProperties = this.getDrinkProperties(itemstack);
        if (drinkProperties != null) {
            return drinkProperties.getMaxItemUseDuration();
        }
        return super.func_77626_a(itemstack);
    }

    public EnumAction func_77661_b(ItemStack itemstack) {
        DrinkProperties drinkProperties = this.getDrinkProperties(itemstack);
        if (drinkProperties != null) {
            return EnumAction.DRINK;
        }
        return EnumAction.NONE;
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand handIn) {
        ItemStack heldItem = player.func_184586_b(handIn);
        DrinkProperties drinkProperties = this.getDrinkProperties(heldItem);
        if (drinkProperties != null) {
            if (player.func_71043_e(false)) {
                player.func_184598_c(handIn);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
            }
            return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
        }
        if (Config.CapsuleFluidPickup) {
            RayTraceResult target = this.func_77621_a(world, player, true);
            if (target.field_72313_a != RayTraceResult.Type.BLOCK) {
                return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)heldItem);
            }
            ItemStack singleBucket = heldItem.func_77946_l();
            singleBucket.func_190920_e(1);
            FluidActionResult filledResult = FluidUtil.tryPickUpFluid((ItemStack)singleBucket, (EntityPlayer)player, (World)world, (BlockPos)target.func_178782_a(), (EnumFacing)target.field_178784_b);
            if (filledResult.isSuccess()) {
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)filledResult.result);
                if (!player.field_71075_bZ.field_75098_d) {
                    heldItem.func_190918_g(1);
                }
                return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)heldItem);
            }
        }
        return super.func_77659_a(world, player, handIn);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable NBTTagCompound nbt) {
        return new FluidHandlerItemForestry(stack, this.type);
    }
}

