/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.climate;

import forestry.api.climate.IClimateState;
import forestry.api.core.ForestryAPI;
import forestry.core.climate.ClimateStates;
import forestry.greenhouse.climate.ClimateSource;
import forestry.greenhouse.climate.ClimateSourceMode;
import forestry.greenhouse.climate.ClimateSourceType;
import forestry.greenhouse.tiles.TileGreenhouseWindow;

public class ClimateSourceWindow
extends ClimateSource<TileGreenhouseWindow> {
    public ClimateSourceWindow(float change, float range) {
        super(change, range, ClimateSourceType.BOTH);
    }

    @Override
    protected void beforeWork() {
        IClimateState currentState = this.container.getState();
        IClimateState biomeState = ForestryAPI.climateManager.getBiomeState(((TileGreenhouseWindow)this.owner).func_145831_w(), ((TileGreenhouseWindow)this.owner).func_174877_v());
        if (biomeState.getTemperature() > currentState.getTemperature()) {
            this.setTemperatureMode(ClimateSourceMode.POSITIVE);
        } else if (biomeState.getTemperature() < currentState.getTemperature()) {
            this.setTemperatureMode(ClimateSourceMode.NEGATIVE);
        } else {
            this.setTemperatureMode(ClimateSourceMode.NONE);
        }
        if (biomeState.getHumidity() > currentState.getHumidity()) {
            this.setHumidityMode(ClimateSourceMode.POSITIVE);
        } else if (biomeState.getHumidity() < currentState.getHumidity()) {
            this.setHumidityMode(ClimateSourceMode.NEGATIVE);
        } else {
            this.setHumidityMode(ClimateSourceMode.NONE);
        }
    }

    @Override
    public boolean canWork(IClimateState currentState, ClimateSourceType oppositeType) {
        return ((TileGreenhouseWindow)this.owner).getMode() == TileGreenhouseWindow.WindowMode.OPEN;
    }

    @Override
    protected void removeResources(IClimateState currentState, ClimateSourceType oppositeType) {
    }

    @Override
    protected IClimateState getChange(ClimateSourceType type, IClimateState target, IClimateState currentState) {
        float temperature = 0.0f;
        float humidity = 0.0f;
        if (type.canChangeHumidity()) {
            humidity = this.humidityMode == ClimateSourceMode.NEGATIVE ? (humidity -= this.change) : (humidity += this.change);
        }
        if (type.canChangeTemperature()) {
            temperature = this.temperatureMode == ClimateSourceMode.NEGATIVE ? (temperature -= this.change) : (temperature += this.change);
        }
        return ClimateStates.extendedOf(temperature, humidity);
    }
}

