/*
 * Decompiled with CFR 0.152.
 */
package forestry.lepidopterology.genetics;

import forestry.api.core.GuiElementAlignment;
import forestry.api.core.IGuiElementHelper;
import forestry.api.core.IGuiElementLayoutHelper;
import forestry.api.genetics.EnumDatabaseTab;
import forestry.api.genetics.IDatabaseTab;
import forestry.api.lepidopterology.IButterfly;
import forestry.core.gui.elements.GuiElementItemStack;
import forestry.core.utils.Translator;
import java.util.Set;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ButterflyProductsTab
implements IDatabaseTab<IButterfly> {
    ButterflyProductsTab() {
    }

    @Override
    public void createElements(IGuiElementHelper layoutHelper, IButterfly individual, ItemStack itemStack) {
        Set<ItemStack> cocoonLoot;
        Set<ItemStack> caterpillarLoot;
        IGuiElementLayoutHelper groupHelper = layoutHelper.layoutHelper((x, y) -> layoutHelper.factory().createHorizontal(x + 4, y, 18).setDistance(2), 90, 0);
        Set<ItemStack> butterflyLoot = individual.getGenome().getPrimary().getButterflyLoot().keySet();
        if (!butterflyLoot.isEmpty()) {
            layoutHelper.addText(Translator.translateToLocal("for.gui.loot.butterfly"), GuiElementAlignment.CENTER);
            butterflyLoot.forEach(stack -> groupHelper.add(new GuiElementItemStack(0, 0, (ItemStack)stack)));
            groupHelper.finish();
        }
        if (!(caterpillarLoot = individual.getGenome().getPrimary().getCaterpillarLoot().keySet()).isEmpty()) {
            layoutHelper.addText(Translator.translateToLocal("for.gui.loot.caterpillar"), GuiElementAlignment.CENTER);
            caterpillarLoot.forEach(stack -> groupHelper.add(new GuiElementItemStack(0, 0, (ItemStack)stack)));
            groupHelper.finish();
        }
        if (!(cocoonLoot = individual.getGenome().getCocoon().getCocoonLoot().keySet()).isEmpty()) {
            layoutHelper.addText(Translator.translateToLocal("for.gui.loot.cocoon"), GuiElementAlignment.CENTER);
            cocoonLoot.forEach(stack -> groupHelper.add(new GuiElementItemStack(0, 0, (ItemStack)stack)));
            groupHelper.finish();
        }
    }

    @Override
    public EnumDatabaseTab getTab() {
        return EnumDatabaseTab.PRODUCTS;
    }
}

