/*
 * Decompiled with CFR 0.152.
 */
package forestry.greenhouse.circuits;

import forestry.api.climate.ClimateType;
import forestry.core.circuits.Circuit;
import forestry.greenhouse.api.climate.IClimateSource;
import forestry.greenhouse.api.climate.IClimateSourceCircuitable;
import forestry.greenhouse.api.climate.IClimateSourceOwner;
import javax.annotation.Nullable;

public class CircuitClimateSource
extends Circuit {
    private ClimateType type;
    private float changeChange;
    private float rangeChange;
    private float energyChange;

    public CircuitClimateSource(String uid, ClimateType type, float changeChange, float rangeChange, float energyChange) {
        super(uid);
        this.type = type;
        this.changeChange = changeChange;
        this.rangeChange = rangeChange;
        this.energyChange = energyChange;
    }

    @Override
    public boolean isCircuitable(Object tile) {
        return tile instanceof IClimateSourceOwner && ((IClimateSourceOwner)tile).isCircuitable();
    }

    @Override
    public void onInsertion(int slot, Object tile) {
        IClimateSourceOwner owner = this.getCircuitable(tile);
        if (owner == null) {
            return;
        }
        IClimateSource source = owner.getClimateSource();
        if (!(source instanceof IClimateSourceCircuitable)) {
            return;
        }
        ((IClimateSourceCircuitable)source).changeSourceConfig(this.type, this.changeChange, this.rangeChange, this.energyChange);
    }

    @Override
    public void onLoad(int slot, Object tile) {
        this.onInsertion(slot, tile);
    }

    @Override
    public void onRemoval(int slot, Object tile) {
        IClimateSourceOwner owner = this.getCircuitable(tile);
        if (owner == null) {
            return;
        }
        IClimateSource source = owner.getClimateSource();
        if (!(source instanceof IClimateSourceCircuitable)) {
            return;
        }
        ((IClimateSourceCircuitable)source).changeSourceConfig(this.type, -this.changeChange, -this.rangeChange, -this.energyChange);
    }

    @Override
    public void onTick(int slot, Object tile) {
    }

    @Nullable
    private IClimateSourceOwner getCircuitable(Object tile) {
        if (!this.isCircuitable(tile)) {
            return null;
        }
        return (IClimateSourceOwner)tile;
    }
}

