/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.config;

import com.google.common.collect.LinkedListMultimap;
import forestry.Forestry;
import forestry.apiculture.HiveConfig;
import forestry.core.config.LocalizedConfiguration;
import forestry.core.fluids.Fluids;
import forestry.core.utils.Log;
import forestry.core.utils.Translator;
import forestry.mail.gui.GuiMailboxInfo;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.relauncher.Side;

public class Config {
    public static final String CATEGORY_COMMON = "common";
    public static final String CATEGORY_FLUIDS = "fluids";
    public static final String CATEGORY_FARM = "farm";
    @Nullable
    public static LocalizedConfiguration configCommon;
    @Nullable
    public static LocalizedConfiguration configFluid;
    @Nullable
    public static String gameMode;
    private static final Set<String> disabledStructures;
    private static final Set<String> disabledFluids;
    private static final Set<String> disabledBlocks;
    public static boolean isDebug;
    public static boolean enableParticleFX;
    public static int humusDegradeDelimiter;
    public static int climateSourceRange;
    public static float climateSourceEnergyModifier;
    public static int greenhouseSize;
    public static boolean pollinateVanillaTrees;
    public static int analyzerEnergyPerWork;
    public static float researchMutationBoostMultiplier;
    public static float maxResearchMutationBoostPercent;
    public static boolean generateApatiteOre;
    public static boolean generateCopperOre;
    public static boolean generateTinOre;
    public static Set<Integer> blacklistedOreDims;
    private static float generateBeehivesAmount;
    public static boolean generateBeehivesDebug;
    public static boolean logHivePlacement;
    public static boolean enableVillagers;
    public static boolean generateTrees;
    public static Set<Integer> blacklistedTreeDims;
    public static boolean doRetrogen;
    public static boolean forceRetrogen;
    public static boolean enableBackpackResupply;
    private static boolean craftingBronzeEnabled;
    public static int farmSize;
    public static float fertilizerModifier;
    public static boolean squareFarms;
    private static boolean enableExUtilEnderLily;
    private static boolean enableExUtilRedOrchid;
    private static boolean enableMagicalCropsSupport;
    public static int planterExtend;
    public static boolean ringFarms;
    public static int ringSize;
    public static boolean mailAlertEnabled;
    public static GuiMailboxInfo.XPosition mailAlertXPosition;
    public static GuiMailboxInfo.YPosition mailAlertYPosition;
    public static boolean craftingStampsEnabled;
    public static final ArrayList<String> collectorStamps;
    public static boolean CapsuleFluidPickup;
    public static int guiTabSpeed;
    public static boolean enableHints;
    public static final LinkedListMultimap<String, String> hints;
    public static boolean enableEnergyStat;

    public static boolean isStructureEnabled(String uid) {
        return !disabledStructures.contains(uid);
    }

    public static boolean isFluidEnabled(Fluids fluidDefinition) {
        return !disabledFluids.contains(fluidDefinition.getTag());
    }

    public static boolean isBlockEnabled(String tag) {
        return !disabledBlocks.contains(tag);
    }

    public static boolean isCraftingBronzeEnabled() {
        return craftingBronzeEnabled;
    }

    public static double getBeehivesAmount() {
        return generateBeehivesAmount;
    }

    public static boolean isExUtilEnderLilyEnabled() {
        return enableExUtilEnderLily;
    }

    public static boolean isExUtilRedOrchidEnabled() {
        return enableExUtilRedOrchid;
    }

    public static boolean isMagicalCropsSupportEnabled() {
        return enableMagicalCropsSupport;
    }

    public static void blacklistTreeDim(int dimID) {
        blacklistedTreeDims.add(dimID);
    }

    public static void blacklistOreDim(int dimID) {
        blacklistedOreDims.add(dimID);
    }

    public static void load(Side side) {
        File configCommonFile = new File(Forestry.instance.getConfigFolder(), "common.cfg");
        configCommon = new LocalizedConfiguration(configCommonFile, "1.2.0");
        Config.loadConfigCommon(side);
        File configFluidsFile = new File(Forestry.instance.getConfigFolder(), "fluids.cfg");
        configFluid = new LocalizedConfiguration(configFluidsFile, "1.0.0");
        Config.loadConfigFluids();
        Config.loadHints();
    }

    @SubscribeEvent
    public static void onConfigChanged(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (!event.getModID().equals("forestry")) {
            return;
        }
        Config.loadConfigCommon(FMLCommonHandler.instance().getSide());
        Config.loadConfigFluids();
    }

    private static void loadConfigCommon(Side side) {
        gameMode = configCommon.getStringLocalized("difficulty", "game.mode", "EASY", new String[]{"OP, EASY, NORMAL, HARD"});
        boolean recreate = configCommon.getBooleanLocalized("difficulty", "recreate.definitions", true);
        if (recreate) {
            Log.info("Recreating all gamemode definitions from the defaults. This may be caused by an upgrade", new Object[0]);
            String string = Translator.translateToLocal("for.config.difficulty.recreate.definitions.comment");
            Property property = configCommon.get("difficulty", "recreate.definitions", true, string);
            property.set(false);
            File opMode = new File(Forestry.instance.getConfigFolder(), "gamemodes/OP.cfg");
            Config.CopyFileToFS(opMode, "/config/forestry/gamemodes/OP.cfg");
            File normalMode = new File(Forestry.instance.getConfigFolder(), "gamemodes/NORMAL.cfg");
            Config.CopyFileToFS(normalMode, "/config/forestry/gamemodes/NORMAL.cfg");
            File hardMode = new File(Forestry.instance.getConfigFolder(), "gamemodes/HARD.cfg");
            Config.CopyFileToFS(hardMode, "/config/forestry/gamemodes/HARD.cfg");
        }
        doRetrogen = configCommon.getBooleanLocalized("world.generate.retrogen", "normal", doRetrogen);
        if (forceRetrogen = configCommon.getBooleanLocalized("world.generate.retrogen", "forced", forceRetrogen)) {
            Property property = configCommon.get("world.generate.retrogen", "forced", false);
            property.set(false);
            Log.info("Enabled force retrogen.", new Object[0]);
            doRetrogen = true;
        } else if (doRetrogen) {
            Log.info("Enabled retrogen.", new Object[0]);
        }
        generateBeehivesAmount = configCommon.getFloatLocalized("world.generate.beehives", "amount", generateBeehivesAmount, 0.0f, 10.0f);
        generateBeehivesDebug = configCommon.getBooleanLocalized("world.generate.beehives", "debug", generateBeehivesDebug);
        HiveConfig.parse(configCommon);
        generateApatiteOre = configCommon.getBooleanLocalized("world.generate.ore", "apatite", generateApatiteOre);
        generateCopperOre = configCommon.getBooleanLocalized("world.generate.ore", "copper", generateCopperOre);
        generateTinOre = configCommon.getBooleanLocalized("world.generate.ore", "tin", generateTinOre);
        for (int dimId : configCommon.get("world.generate.ore", "dimBlacklist", new int[0]).getIntList()) {
            blacklistedOreDims.add(dimId);
        }
        enableVillagers = configCommon.getBooleanLocalized("world.generate", "villagers", enableVillagers);
        generateTrees = configCommon.getBooleanLocalized("world.generate", "trees", generateTrees);
        for (int dimId : configCommon.get("world.generate.trees", "dimBlacklist", new int[0]).getIntList()) {
            blacklistedTreeDims.add(dimId);
        }
        craftingBronzeEnabled = configCommon.getBooleanLocalized("crafting", "bronze", craftingBronzeEnabled);
        craftingStampsEnabled = configCommon.getBooleanLocalized("crafting.stamps", "enabled", true);
        String[] stringArray = new String[]{"1n", "2n", "5n", "10n", "20n", "50n", "100n"};
        String[] defaultCollectors = new String[]{"20n", "50n", "100n"};
        String[] stamps = configCommon.getStringListLocalized("crafting.stamps", "disabled", defaultCollectors, stringArray);
        try {
            collectorStamps.addAll(Arrays.asList(stamps));
        }
        catch (RuntimeException ex) {
            Log.warning("Failed to read config for 'crafting.stamps.disabled', setting to default.", new Object[0]);
            Property property = configCommon.get("crafting.stamps", "disabled", defaultCollectors);
            property.setToDefault();
            collectorStamps.addAll(Arrays.asList(defaultCollectors));
        }
        pollinateVanillaTrees = configCommon.getBooleanLocalized("genetics", "pollinate.vanilla.trees", pollinateVanillaTrees);
        analyzerEnergyPerWork = configCommon.getIntLocalized("genetics", "analyzerblock.energy.use", 20320, 0, 100000);
        researchMutationBoostMultiplier = configCommon.getFloatLocalized("genetics.research.boost", "multiplier", researchMutationBoostMultiplier, 1.0f, 1000.0f);
        maxResearchMutationBoostPercent = configCommon.getFloatLocalized("genetics.research.boost", "max.percent", maxResearchMutationBoostPercent, 0.0f, 100.0f);
        enableBackpackResupply = configCommon.getBooleanLocalized("performance", "backpacks.resupply", enableBackpackResupply);
        humusDegradeDelimiter = configCommon.getIntLocalized("tweaks.humus", "degradeDelimiter", humusDegradeDelimiter, 1, 10);
        if (side == Side.CLIENT) {
            mailAlertEnabled = configCommon.getBooleanLocalized("tweaks.gui.mail.alert", "enabled", mailAlertEnabled);
            mailAlertXPosition = (GuiMailboxInfo.XPosition)configCommon.getEnumLocalized("tweaks.gui.mail.alert", "xPosition", mailAlertXPosition, GuiMailboxInfo.XPosition.values());
            mailAlertYPosition = (GuiMailboxInfo.YPosition)configCommon.getEnumLocalized("tweaks.gui.mail.alert", "yPosition", mailAlertYPosition, GuiMailboxInfo.YPosition.values());
            guiTabSpeed = configCommon.getIntLocalized("tweaks.gui.tabs", "speed", guiTabSpeed, 1, 50);
            enableHints = configCommon.getBooleanLocalized("tweaks.gui.tabs", "hints", enableHints);
            enableEnergyStat = configCommon.getBooleanLocalized("tweaks.gui.tabs", "energy", enableEnergyStat);
            enableParticleFX = configCommon.getBooleanLocalized("performance", "particleFX", enableParticleFX);
        }
        farmSize = configCommon.getIntLocalized("tweaks.farms", "size", farmSize, 1, 3);
        fertilizerModifier = configCommon.getFloatLocalized("tweaks.farms", "fertilizer", fertilizerModifier, 0.1f, 5.0f);
        squareFarms = configCommon.getBooleanLocalized("tweaks.farms", "square", squareFarms);
        enableExUtilEnderLily = configCommon.getBooleanLocalized("tweaks.farms", "enderlily", enableExUtilEnderLily);
        enableExUtilRedOrchid = configCommon.getBooleanLocalized("tweaks.farms", "redorchid", enableExUtilRedOrchid);
        enableMagicalCropsSupport = configCommon.getBooleanLocalized("tweaks.farms", "magicalcrops", enableMagicalCropsSupport);
        planterExtend = configCommon.getIntLocalized("tweaks.cultivation", "extend", planterExtend, 1, 15);
        ringFarms = configCommon.getBooleanLocalized("tweaks.cultivation", "ring", ringFarms);
        ringSize = configCommon.getIntLocalized("tweaks.cultivation", "ring_size", ringSize, 1, 8);
        CapsuleFluidPickup = configCommon.getBooleanLocalized("tweaks", "capsule", CapsuleFluidPickup);
        climateSourceRange = configCommon.getIntLocalized("tweaks.greenhouse", "range", climateSourceRange, 9, 270);
        climateSourceEnergyModifier = configCommon.getFloatLocalized("tweaks.greenhouse", "energy", climateSourceEnergyModifier, 0.0f, 15.0f);
        greenhouseSize = configCommon.getIntLocalized("tweaks.greenhouse", "size", greenhouseSize, 1, 5);
        String[] availableStructures = new String[]{"alveary3x3", "farm3x3", "farm3x4", "farm3x5", "farm4x4", "farm5x5"};
        String[] disabledStructureArray = disabledStructures.toArray(new String[disabledStructures.size()]);
        disabledStructureArray = configCommon.getStringListLocalized("structures", "disabled", disabledStructureArray, availableStructures);
        disabledStructures.addAll(Arrays.asList(disabledStructureArray));
        for (String str : disabledStructures) {
            Log.debug("Disabled structure '%s'.", str);
        }
        isDebug = configCommon.getBooleanLocalized("debug", "enabled", isDebug);
        configCommon.save();
    }

    private static void loadConfigFluids() {
        for (Fluids fluid : Fluids.values()) {
            String fluidName = Translator.translateToLocal("fluid." + fluid.getTag());
            boolean enabledFluid = !disabledFluids.contains(fluid.getTag());
            String enableFluidComment = Translator.translateToLocalFormatted("for.config.fluids.enable.format", fluidName);
            enabledFluid = configFluid.getBoolean("enableFluid", fluid.getTag(), enabledFluid, enableFluidComment);
            if (!enabledFluid) {
                disabledFluids.add(fluid.getTag());
            }
            boolean enabledFluidBlock = !disabledBlocks.contains(fluid.getTag());
            String enableFluidBlockComment = Translator.translateToLocalFormatted("for.config.fluid.blocks.enable.format", fluidName);
            enabledFluidBlock = configFluid.getBoolean("enableFluidBlock", fluid.getTag(), enabledFluidBlock, enableFluidBlockComment);
            if (enabledFluidBlock) continue;
            disabledBlocks.add(fluid.getTag());
        }
        configFluid.save();
    }

    private static void CopyFileToFS(File destination, String resourcePath) {
        InputStream stream = Config.class.getResourceAsStream(resourcePath);
        byte[] buffer = new byte[4096];
        try {
            int readBytes;
            if (destination.getParentFile() != null) {
                destination.getParentFile().mkdirs();
            }
            if (!destination.exists() && !destination.createNewFile()) {
                return;
            }
            FileOutputStream outstream = new FileOutputStream(destination);
            while ((readBytes = stream.read(buffer)) > 0) {
                ((OutputStream)outstream).write(buffer, 0, readBytes);
            }
        }
        catch (FileNotFoundException e) {
            Log.error("File not found.", e);
        }
        catch (IOException e) {
            Log.error("Failed to copy file.", e);
        }
    }

    private static void loadHints() {
        Properties prop = new Properties();
        try {
            InputStream hintStream = Config.class.getResourceAsStream("/config/forestry/hints.properties");
            prop.load(hintStream);
        }
        catch (IOException | NullPointerException e) {
            Log.error("Failed to load hints file.", e);
        }
        for (String key : prop.stringPropertyNames()) {
            String[] parsedHints;
            for (String parsedHint : parsedHints = Config.parseHints(prop.getProperty(key))) {
                hints.put((Object)key, (Object)parsedHint);
            }
        }
    }

    private static String[] parseHints(String list) {
        if (list.isEmpty()) {
            return new String[0];
        }
        return list.split("[;]+");
    }

    static {
        disabledStructures = new HashSet<String>();
        disabledFluids = new HashSet<String>();
        disabledBlocks = new HashSet<String>();
        isDebug = false;
        enableParticleFX = true;
        humusDegradeDelimiter = 3;
        climateSourceRange = 36;
        climateSourceEnergyModifier = 1.5f;
        greenhouseSize = 4;
        pollinateVanillaTrees = true;
        analyzerEnergyPerWork = 20320;
        researchMutationBoostMultiplier = 1.5f;
        maxResearchMutationBoostPercent = 5.0f;
        generateApatiteOre = true;
        generateCopperOre = true;
        generateTinOre = true;
        blacklistedOreDims = new HashSet<Integer>();
        generateBeehivesAmount = 1.0f;
        generateBeehivesDebug = false;
        logHivePlacement = false;
        enableVillagers = true;
        generateTrees = true;
        blacklistedTreeDims = new HashSet<Integer>();
        doRetrogen = false;
        forceRetrogen = false;
        enableBackpackResupply = true;
        craftingBronzeEnabled = true;
        farmSize = 2;
        fertilizerModifier = 1.0f;
        squareFarms = false;
        enableExUtilEnderLily = true;
        enableExUtilRedOrchid = true;
        enableMagicalCropsSupport = true;
        planterExtend = 4;
        ringFarms = true;
        ringSize = 4;
        mailAlertEnabled = true;
        mailAlertXPosition = GuiMailboxInfo.XPosition.LEFT;
        mailAlertYPosition = GuiMailboxInfo.YPosition.TOP;
        craftingStampsEnabled = true;
        collectorStamps = new ArrayList();
        CapsuleFluidPickup = false;
        guiTabSpeed = 8;
        enableHints = true;
        hints = LinkedListMultimap.create();
        enableEnergyStat = true;
    }
}

