/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import com.google.common.collect.ImmutableSet;
import forestry.api.farming.FarmDirection;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmHousing;
import forestry.api.farming.IFarmProperties;
import forestry.api.farming.IFarmable;
import forestry.core.utils.BlockUtil;
import forestry.farming.logic.FarmLogicHomogeneous;
import forestry.farming.logic.crops.CropDestroy;
import forestry.farming.logic.farmables.FarmableChorus;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmLogicEnder
extends FarmLogicHomogeneous {
    private static final Set<EnumFacing> VALID_DIRECTIONS = ImmutableSet.of((Object)EnumFacing.UP, (Object)EnumFacing.NORTH, (Object)EnumFacing.SOUTH, (Object)EnumFacing.WEST, (Object)EnumFacing.EAST);
    private final IFarmable chorusFarmable;
    private final Map<BlockPos, Integer> lastExtentsHarvest = new HashMap<BlockPos, Integer>();

    public FarmLogicEnder(IFarmProperties properties, boolean isManual) {
        super(properties, isManual);
        this.chorusFarmable = FarmableChorus.INSTANCE;
    }

    @Override
    public String getUnlocalizedName() {
        return "for.farm.ender";
    }

    @Override
    public ItemStack getIconItemStack() {
        return new ItemStack(Items.field_151061_bv);
    }

    @Override
    public int getFertilizerConsumption() {
        return 20;
    }

    @Override
    public int getWaterConsumption(float hydrationModifier) {
        return 0;
    }

    @Override
    public NonNullList<ItemStack> collect(World world, IFarmHousing farmHousing) {
        NonNullList products = this.produce;
        this.produce = this.collectEntityItems(world, farmHousing, true);
        return products;
    }

    @Override
    public Collection<ICrop> harvest(World world, BlockPos pos, FarmDirection direction, int extent) {
        int lastExtent;
        if (!this.lastExtentsHarvest.containsKey(pos)) {
            this.lastExtentsHarvest.put(pos, 0);
        }
        if ((lastExtent = this.lastExtentsHarvest.get(pos).intValue()) > extent) {
            lastExtent = 0;
        }
        BlockPos position = this.translateWithOffset(pos.func_177984_a(), direction, lastExtent);
        Collection<ICrop> crops = this.harvestBlocks(world, position);
        this.lastExtentsHarvest.put(pos, ++lastExtent);
        return crops;
    }

    private Collection<ICrop> harvestBlocks(World world, BlockPos position) {
        if (world.func_175623_d(position)) {
            return Collections.emptySet();
        }
        ICrop crop = this.getCrop(world, position);
        if (crop != null) {
            return Collections.singleton(crop);
        }
        Stack<ICrop> crops = new Stack<ICrop>();
        Stack<ICrop> plants = new Stack<ICrop>();
        this.harvestBlock(world, position, EnumFacing.DOWN, plants, crops);
        if (!crops.isEmpty()) {
            return crops;
        }
        return plants;
    }

    private boolean harvestBlock(World world, BlockPos pos, EnumFacing from, Stack<ICrop> plants, Stack<ICrop> flowers) {
        IBlockState blockState = world.func_180495_p(pos);
        if (blockState.func_177230_c() == Blocks.field_185766_cS) {
            ICrop crop = this.chorusFarmable.getCropAt(world, pos, blockState);
            if (crop != null) {
                flowers.push(crop);
                return false;
            }
            return false;
        }
        if (blockState.func_177230_c() == Blocks.field_185765_cR) {
            boolean canHarvest = true;
            for (EnumFacing facing : VALID_DIRECTIONS) {
                if (facing == from) continue;
                canHarvest &= this.harvestBlock(world, pos.func_177972_a(facing), facing.func_176734_d(), plants, flowers);
            }
            if (canHarvest) {
                plants.push(new CropDestroy(world, Blocks.field_185765_cR.func_176223_P(), pos, null));
            }
            return canHarvest;
        }
        return true;
    }

    @Override
    protected boolean maintainGermlings(World world, IFarmHousing farmHousing, BlockPos pos, FarmDirection direction, int extent) {
        for (int i = 0; i < extent; ++i) {
            BlockPos soilPos;
            IBlockState blockState;
            BlockPos position = this.translateWithOffset(pos, direction, i);
            IBlockState state = world.func_180495_p(position);
            if (!world.func_175623_d(position) && !BlockUtil.isReplaceableBlock(state, world, position) || !this.isAcceptedSoil(blockState = world.func_180495_p(soilPos = position.func_177977_b())) || !this.trySetCrop(world, farmHousing, position, direction)) continue;
            return true;
        }
        return false;
    }
}

