/*
 * Decompiled with CFR 0.152.
 */
package forestry.core;

import forestry.api.apiculture.BeeManager;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.arboriculture.EnumGermlingType;
import forestry.api.arboriculture.TreeManager;
import forestry.api.core.ForestryAPI;
import forestry.api.core.Tabs;
import forestry.api.lepidopterology.ButterflyManager;
import forestry.api.lepidopterology.EnumFlutterType;
import forestry.apiculture.genetics.Bee;
import forestry.apiculture.genetics.BeeDefinition;
import forestry.arboriculture.genetics.Tree;
import forestry.arboriculture.genetics.TreeDefinition;
import forestry.core.ModuleCore;
import forestry.lepidopterology.genetics.Butterfly;
import forestry.lepidopterology.genetics.ButterflyDefinition;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class CreativeTabForestry
extends CreativeTabs {
    public static final CreativeTabs tabForestry;
    private final int icon;

    private CreativeTabForestry(int icon, String label) {
        super(label);
        this.icon = icon;
    }

    public ItemStack func_151244_d() {
        Item iconItem;
        switch (this.icon) {
            case 1: {
                iconItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry", "ffarm"));
                break;
            }
            case 2: {
                return BeeManager.beeRoot.getMemberStack(new Bee(BeeDefinition.FOREST.getGenome()), EnumBeeType.DRONE);
            }
            case 3: {
                return TreeManager.treeRoot.getMemberStack(new Tree(TreeDefinition.Oak.getGenome()), EnumGermlingType.SAPLING);
            }
            case 4: {
                return ButterflyManager.butterflyRoot.getMemberStack(new Butterfly(ButterflyDefinition.Brimstone.getGenome()), EnumFlutterType.BUTTERFLY);
            }
            default: {
                iconItem = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("forestry", "fertilizerCompound"));
            }
        }
        if (iconItem == null) {
            iconItem = ModuleCore.getItems().wrench;
        }
        return new ItemStack(iconItem);
    }

    public ItemStack func_78016_d() {
        return this.func_151244_d();
    }

    static {
        if (ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "farming"))) {
            Tabs.tabAgriculture = new CreativeTabForestry(1, "agriculture");
        }
        if (ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "apiculture"))) {
            Tabs.tabApiculture = new CreativeTabForestry(2, "apiculture");
        }
        if (ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "arboriculture"))) {
            Tabs.tabArboriculture = new CreativeTabForestry(3, "arboriculture");
        }
        if (ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "lepidopterology"))) {
            Tabs.tabLepidopterology = new CreativeTabForestry(4, "lepidopterology");
        }
        tabForestry = new CreativeTabForestry(0, "forestry");
    }
}

