/*
 * Decompiled with CFR 0.152.
 */
package forestry.sorting;

import forestry.api.core.ILocatable;
import forestry.api.genetics.IFilterLogic;
import forestry.api.genetics.IFilterRegistry;
import forestry.api.genetics.IFilterRuleType;
import forestry.sorting.DefaultFilterRuleType;
import forestry.sorting.FilterLogic;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import javax.annotation.Nullable;

public class FilterRegistry
implements IFilterRegistry {
    private final HashMap<String, IFilterRuleType> filterByName = new LinkedHashMap<String, IFilterRuleType>();
    private final HashMap<String, Integer> filterIDByName = new LinkedHashMap<String, Integer>();
    private final HashMap<Integer, IFilterRuleType> filterByID = new LinkedHashMap<Integer, IFilterRuleType>();
    private int ids;

    @Override
    public void registerFilter(IFilterRuleType rule) {
        this.filterByName.put(rule.getUID(), rule);
        this.filterIDByName.put(rule.getUID(), this.ids++);
        this.filterByID.put(this.ids - 1, rule);
    }

    @Override
    public Collection<IFilterRuleType> getRules() {
        return this.filterByName.values();
    }

    @Override
    public IFilterRuleType getDefaultRule() {
        return DefaultFilterRuleType.CLOSED;
    }

    @Override
    @Nullable
    public IFilterRuleType getRule(String uid) {
        return this.filterByName.get(uid);
    }

    @Override
    public int getId(IFilterRuleType rule) {
        return this.filterIDByName.get(rule.getUID());
    }

    @Override
    public IFilterLogic createLogic(ILocatable locatable, IFilterLogic.INetworkHandler networkHandler) {
        return new FilterLogic(locatable, networkHandler);
    }

    @Override
    @Nullable
    public IFilterRuleType getRule(int id) {
        return this.filterByID.get(id);
    }
}

