/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.IFarmRegistry;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.farming.logic.FarmableAgingCrop;
import forestry.farming.logic.FarmableRusticGrape;
import forestry.farming.logic.FarmableRusticSapling;
import forestry.plugins.CompatPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.item.ItemStack;

@ForestryModule(containerID="forestry_compat", moduleID="rustic", name="rustic", author="Nedelosk", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.rustic.description")
public class PluginRustic
extends CompatPlugin {
    public PluginRustic() {
        super("Rustic", "rustic");
    }

    @Override
    public void registerRecipes() {
        ImmutableList fruits = ImmutableList.of((Object)"tomato", (Object)"chili_pepper");
        ImmutableList crops = ImmutableList.of((Object)"tomato", (Object)"chili");
        PropertyInteger cropAge = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
        int seedAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        int juiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple");
        IFarmRegistry farmRegistry = ForestryAPI.farmRegistry;
        ItemStack grapes = this.getItemStack("grapes");
        ItemStack grapeSeeds = this.getItemStack("grape_stem");
        Block grapeLeaves = this.getBlock("grape_leaves");
        if (grapeSeeds != null) {
            RecipeManagers.squeezerManager.addRecipe(10, grapeSeeds, Fluids.SEED_OIL.getFluid(seedAmount));
        }
        if (grapes != null) {
            RecipeManagers.squeezerManager.addRecipe(10, grapes, Fluids.JUICE.getFluid(juiceAmount / 12));
        }
        if (grapeLeaves != null) {
            farmRegistry.registerFarmables("farmOrchard", new FarmableRusticGrape(grapeLeaves));
        }
        ItemStack sapling = this.getItemStack("sapling");
        ItemStack ironBerries = this.getItemStack("ironberries");
        ItemStack olives = this.getItemStack("olives");
        if (sapling != null && ironBerries != null && olives != null) {
            farmRegistry.registerFarmables("farmArboreal", new FarmableRusticSapling(sapling.func_77973_b(), new ItemStack[]{ironBerries, olives}));
        }
        for (int i = 0; i < fruits.size(); ++i) {
            String fruitName = (String)fruits.get(i);
            ItemStack seeds = this.getItemStack(fruitName + "_seeds");
            Block block = this.getBlock((String)crops.get(i) + "_crop");
            ItemStack fruit = this.getItemStack(fruitName);
            if (seeds != null) {
                RecipeManagers.squeezerManager.addRecipe(10, seeds, Fluids.SEED_OIL.getFluid(seedAmount));
            }
            if (fruit != null) {
                RecipeManagers.squeezerManager.addRecipe(10, fruit, Fluids.JUICE.getFluid(juiceAmount / 25));
            }
            if (seeds == null || block == null) continue;
            farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(seeds, block, (IProperty<Integer>)cropAge, 3, 2));
        }
    }
}

