/*
 * Decompiled with CFR 0.152.
 */
package forestry.farming.logic;

import com.google.common.base.Preconditions;
import forestry.api.farming.ICrop;
import forestry.api.farming.IFarmable;
import forestry.farming.logic.CropDestroy;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class FarmableRusticGrape
implements IFarmable {
    public static final PropertyBool GRAPES = PropertyBool.func_177716_a((String)"grapes");
    private final Block cropBlock;

    public FarmableRusticGrape(Block cropBlock) {
        Preconditions.checkNotNull((Object)cropBlock);
        this.cropBlock = cropBlock;
    }

    @Override
    public boolean isSaplingAt(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        return blockState.func_177230_c() == this.cropBlock;
    }

    @Override
    @Nullable
    public ICrop getCropAt(World world, BlockPos pos, IBlockState blockState) {
        if (blockState.func_177230_c() != this.cropBlock) {
            return null;
        }
        if (!((Boolean)blockState.func_177229_b((IProperty)GRAPES)).booleanValue()) {
            return null;
        }
        IBlockState replantState = this.getReplantState(blockState);
        return new CropDestroy(world, blockState, pos, replantState);
    }

    @Nullable
    protected IBlockState getReplantState(IBlockState blockState) {
        return blockState.func_177226_a((IProperty)GRAPES, (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean isGermling(ItemStack itemstack) {
        return false;
    }

    @Override
    public boolean plantSaplingAt(EntityPlayer player, ItemStack germling, World world, BlockPos pos) {
        return false;
    }

    @Override
    public boolean isWindfall(ItemStack itemstack) {
        return false;
    }
}

