/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import com.google.common.collect.ImmutableList;
import forestry.api.core.ForestryAPI;
import forestry.api.farming.IFarmRegistry;
import forestry.api.modules.ForestryModule;
import forestry.api.recipes.RecipeManagers;
import forestry.core.fluids.Fluids;
import forestry.farming.logic.FarmableAgingCrop;
import forestry.plugins.CompatPlugin;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;

@ForestryModule(containerID="forestry_compat", moduleID="roots", name="Roots", author="Nedelosk", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.roots.description")
public class PluginRoots
extends CompatPlugin {
    public PluginRoots() {
        super("Roots", "roots");
    }

    @Override
    public void registerRecipes() {
        ImmutableList crops = ImmutableList.of((Object)"moonglow", (Object)"terra_moss", (Object)"aubergine");
        ImmutableList seeds = ImmutableList.of((Object)"moontinged_seed", (Object)"terra_moss_spore", (Object)"aubergine_seeds");
        ImmutableList fruits = ImmutableList.of((Object)"moonglow_leaf", (Object)"terra_moss_ball", (Object)"aubergine_item");
        IFarmRegistry farmRegistry = ForestryAPI.farmRegistry;
        int seedAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.seed");
        int juiceAmount = ForestryAPI.activeMode.getIntegerSetting("squeezer.liquid.apple") / 25;
        for (int i = 0; i < fruits.size(); ++i) {
            ItemStack seed = this.getItemStack((String)seeds.get(i));
            Block block = this.getBlock((String)crops.get(i));
            ItemStack fruit = this.getItemStack((String)fruits.get(i));
            if (seed != null && i != 1) {
                RecipeManagers.squeezerManager.addRecipe(10, seed, Fluids.SEED_OIL.getFluid(seedAmount));
            }
            if (fruit != null && i == 2) {
                RecipeManagers.squeezerManager.addRecipe(10, fruit, Fluids.JUICE.getFluid(juiceAmount));
            }
            if (seed == null || block == null) continue;
            farmRegistry.registerFarmables("farmWheat", new FarmableAgingCrop(seed, block, (IProperty<Integer>)BlockCrops.field_176488_a, 7));
            farmRegistry.registerFarmables("farmOrchard", new FarmableAgingCrop(seed, block, (IProperty<Integer>)BlockCrops.field_176488_a, 7, 0));
        }
    }
}

