/*
 * Decompiled with CFR 0.152.
 */
package forestry.apiculture;

import forestry.api.apiculture.hives.IHiveRegistry;
import forestry.core.config.LocalizedConfiguration;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class HiveConfig {
    private static final Map<IHiveRegistry.HiveType, HiveConfig> configs = new EnumMap<IHiveRegistry.HiveType, HiveConfig>(IHiveRegistry.HiveType.class);
    private static final String CATEGORY = "world.generate.beehives.blacklist";
    private final Set<BiomeDictionary.Type> blacklistedTypes = new HashSet<BiomeDictionary.Type>();
    private final Set<Biome> blacklistedBiomes = new HashSet<Biome>();
    private static final Set<Integer> blacklistedDims = new HashSet<Integer>();

    public static void parse(LocalizedConfiguration config) {
        config.addCategoryCommentLocalized(CATEGORY);
        for (int dimId : config.get("world.generate.beehives", "dimBlacklist", new int[0]).getIntList()) {
            blacklistedDims.add(dimId);
        }
        for (IHiveRegistry.HiveType type : IHiveRegistry.HiveType.values()) {
            String[] entries = config.get(CATEGORY, type.func_176610_l(), new String[0]).getStringList();
            configs.put(type, new HiveConfig(entries));
        }
    }

    public HiveConfig(String[] entries) {
        for (String entry : entries) {
            BiomeDictionary.Type type = BiomeDictionary.Type.getType((String)entry, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
            Biome biome = (Biome)ForgeRegistries.BIOMES.getValue(new ResourceLocation(entry));
            if (type != null) {
                this.blacklistedTypes.add(type);
                continue;
            }
            if (biome == null) continue;
            this.blacklistedBiomes.add(biome);
        }
    }

    public static boolean isBlacklisted(IHiveRegistry.HiveType type, Biome biome) {
        HiveConfig config = configs.get((Object)type);
        if (config == null) {
            return false;
        }
        return config.isBlacklisted(biome);
    }

    private boolean isBlacklisted(Biome biome) {
        if (this.blacklistedBiomes.contains(biome)) {
            return true;
        }
        return BiomeDictionary.getTypes((Biome)biome).stream().anyMatch(this.blacklistedTypes::contains);
    }

    public static boolean isDimBlacklisted(int dimId) {
        return blacklistedDims.contains(dimId);
    }
}

