/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.greenhouse.tiles;

import javax.annotation.Nullable;

import net.minecraft.block.state.IBlockState;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

import forestry.core.network.packets.PacketActiveUpdate;
import forestry.core.tiles.IActivatable;
import forestry.core.utils.NetworkUtil;
import forestry.greenhouse.api.climate.IClimateSource;
import forestry.greenhouse.api.climate.IClimateSourceOwner;
import forestry.greenhouse.blocks.BlockGreenhouseWindow;
import forestry.greenhouse.climate.ClimateSourceWindow;

public class TileGreenhouseWindow extends TileEntity implements IActivatable, IClimateSourceOwner {
	private final ClimateSourceWindow source;
	@Nullable
	private WindowMode mode;
	private String glass;
	private boolean active;

	public TileGreenhouseWindow() {
		source = new ClimateSourceWindow(0.05F, 5F);
		source.setOwner(this);
		glass = "glass";
	}

	@Override
	public IClimateSource getClimateSource() {
		return source;
	}

	@Override
	public boolean isCircuitable() {
		return false;
	}

	@Override
	public BlockPos getCoordinates() {
		return field_174879_c;
	}

	/* IActivatable */
	@Override
	public boolean isActive() {
		return active;
	}

	@Override
	public void setActive(boolean active) {
		if (this.active == active) {
			return;
		}

		this.active = active;

		if (field_145850_b != null) {
			if (field_145850_b.field_72995_K) {
				field_145850_b.func_175704_b(getCoordinates(), getCoordinates());
			} else {
				NetworkUtil.sendNetworkPacket(new PacketActiveUpdate(this), getCoordinates(), field_145850_b);
			}
		}
	}

	@Override
	public World getWorldObj() {
		return field_145850_b;
	}

	public void onNeighborBlockChange() {
		WindowMode otherMode = isBlocked();
		if (getMode() != WindowMode.PLAYER && getMode() != WindowMode.CONTROL && otherMode != getMode()) {
			setMode(otherMode);
		}
	}

	public WindowMode isBlocked() {
		if (field_145850_b == null) {
			return WindowMode.BLOCK;
		}
		if (!field_145850_b.func_175667_e(field_174879_c)) {
			return WindowMode.BLOCK;
		}
		IBlockState state = field_145850_b.func_180495_p(field_174879_c);
		BlockPos blockedPos;
		if (((BlockGreenhouseWindow) state.func_177230_c()).isRoofWindow()) {
			blockedPos = getCoordinates().func_177972_a(EnumFacing.UP);
		} else {
			blockedPos = getCoordinates().func_177972_a(state.func_177229_b(BlockGreenhouseWindow.FACING));
		}
		return field_145850_b.func_175623_d(blockedPos) ? WindowMode.OPEN : WindowMode.BLOCK;
	}

	@Override
	public void func_145839_a(NBTTagCompound data) {
		super.func_145839_a(data);
		if (data.func_74764_b("mode")) {
			setMode(WindowMode.values()[data.func_74765_d("mode")]);
		}
		if (data.func_74764_b("Glass")) {
			glass = data.func_74779_i("Glass");
		}
		source.readFromNBT(data);
	}

	@Override
	public NBTTagCompound func_189515_b(NBTTagCompound data) {
		if (mode != null) {
			data.func_74777_a("mode", (short) mode.ordinal());
		}
		if (glass != null) {
			data.func_74778_a("Glass", glass);
		}
		source.writeToNBT(data);
		return super.func_189515_b(data);
	}

	@Override
	public NBTTagCompound func_189517_E_() {
		return func_189515_b(new NBTTagCompound());
	}

	@Override
	public boolean shouldRefresh(World world, BlockPos pos, IBlockState oldState, IBlockState newSate) {
		return oldState.func_177230_c() != newSate.func_177230_c();
	}

	public String getGlass() {
		return glass;
	}

	public void setGlass(String glass) {
		this.glass = glass;
	}

	@Nullable
	public WindowMode getMode() {
		return mode;
	}

	public void setMode(WindowMode mode) {
		this.mode = mode;
		setActive(mode == WindowMode.OPEN);
	}

	public enum WindowMode {
		PLAYER, BLOCK, CONTROL, OPEN
	}

}
