/*******************************************************************************
 * Copyright (c) 2011-2014 SirSengir.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the GNU Lesser Public License v3
 * which accompanies this distribution, and is available at
 * http://www.gnu.org/licenses/lgpl-3.0.txt
 *
 * Various Contributors including, but not limited to:
 * SirSengir (original work), CovertJaguar, Player, Binnie, MysteriousAges
 ******************************************************************************/
package forestry.lepidopterology.entities;

import net.minecraft.entity.player.EntityPlayer;

public class AIButterflyFlee extends AIButterflyMovement {

	public AIButterflyFlee(EntityButterfly entity) {
		super(entity);
		func_75248_a(3);
	}

	@Override
	public boolean func_75250_a() {

		EntityPlayer player = entity.field_70170_p.func_72890_a(entity, entity.getButterfly().getGenome().getPrimary().getFlightDistance());

		if (player == null || player.func_70093_af()) {
			return false;
		}

		if (!entity.func_70635_at().func_75522_a(player)) {
			return false;
		}

		flightTarget = getRandomDestination();
		if (flightTarget == null) {
			return false;
		}

		if (player.func_70092_e(flightTarget.field_72450_a, flightTarget.field_72448_b, flightTarget.field_72449_c) < player.func_70068_e(entity)) {
			return false;
		}

		entity.setDestination(flightTarget);
		entity.setState(EnumButterflyState.FLYING);
		return true;
	}

}
