/*
 * Decompiled with CFR 0.152.
 */
package forestry.plugins;

import forestry.api.circuits.ChipsetManager;
import forestry.api.circuits.ICircuit;
import forestry.api.circuits.ICircuitLayout;
import forestry.api.core.ForestryAPI;
import forestry.api.modules.ForestryModule;
import forestry.core.ModuleCore;
import forestry.core.circuits.Circuits;
import forestry.core.config.Config;
import forestry.core.items.EnumElectronTube;
import forestry.core.utils.BlockUtil;
import forestry.core.utils.Log;
import forestry.core.utils.ModUtil;
import forestry.farming.FarmRegistry;
import forestry.farming.circuits.CircuitFarmLogic;
import forestry.farming.logic.FarmLogicExU;
import forestry.farming.logic.FarmableAgingCrop;
import forestry.modules.BlankForestryModule;
import java.util.Collections;
import java.util.function.Consumer;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

@ForestryModule(containerID="forestry_compat", moduleID="extra.utilities", name="ExtraUtilities", author="Nirek", url="http://forestry.sengir.net/", unlocalizedDescription="for.module.extrautilities.description")
public class PluginExtraUtilities
extends BlankForestryModule {
    private static final String ExU = "extrautils2";

    @Override
    public boolean isAvailable() {
        return ModUtil.isModLoaded(ExU);
    }

    @Override
    public String getFailMessage() {
        return "ExtraUtilities not found";
    }

    @Override
    public void doInit() {
        if (Config.isExUtilRedOrchidEnabled()) {
            this.registerExPlant("Orchid", "redorchid", "Red Orchid", Blocks.field_150450_ax, circuit -> {
                Circuits.farmOrchidManaged = circuit;
            });
        }
        if (Config.isExUtilEnderLilyEnabled()) {
            this.registerExPlant("Ender", "enderlilly", "Ender Lily", Blocks.field_150377_bs, circuit -> {
                Circuits.farmEnderManaged = circuit;
            });
        }
    }

    @Override
    public void registerRecipes() {
        ICircuitLayout layoutManaged;
        if (!ForestryAPI.enabledModules.contains(new ResourceLocation("forestry", "farming"))) {
            return;
        }
        if (Circuits.farmEnderManaged != null) {
            layoutManaged = ChipsetManager.circuitRegistry.getLayout("forestry.farms.managed");
            ChipsetManager.solderManager.addRecipe(layoutManaged, ModuleCore.getItems().tubes.get(EnumElectronTube.ENDER, 1), Circuits.farmEnderManaged);
        }
        if (Circuits.farmOrchidManaged != null) {
            layoutManaged = ChipsetManager.circuitRegistry.getLayout("forestry.farms.managed");
            ChipsetManager.solderManager.addRecipe(layoutManaged, ModuleCore.items.tubes.get(EnumElectronTube.ORCHID, 1), Circuits.farmOrchidManaged);
        }
    }

    private void registerExPlant(String id, String itemResourceName, String itemName, Block soil, Consumer<ICircuit> assignTo) {
        Block plantBlock = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(ExU, itemResourceName));
        Item plantItem = Item.func_150898_a((Block)plantBlock);
        if (plantBlock == Blocks.field_150350_a) {
            Log.error("Could not find {} block.", itemName);
        } else if (plantItem == null) {
            Log.error("Could not find {} item.", itemName);
        } else {
            IProperty<Integer> growthProperty = BlockUtil.getProperty(plantBlock, "growth", Integer.class);
            if (growthProperty == null) {
                Log.error("Could not find the growth property of {}.", itemName);
            } else {
                int harvestAge = (Integer)Collections.max(growthProperty.func_177700_c());
                int replantAge = (Integer)plantBlock.func_176223_P().func_177229_b(growthProperty);
                FarmRegistry.getInstance().registerFarmables(itemName, new FarmableAgingCrop(new ItemStack(plantItem), plantBlock, growthProperty, harvestAge, replantAge));
                assignTo.accept(new CircuitFarmLogic("managed" + id, new FarmLogicExU("Managed " + itemName + " Farm", plantItem, soil, itemName)));
            }
        }
    }
}

